<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-08-19
 * Time: 1:56 PM
 */
/*Build a dropdown box */
add_action("wp_ajax_mxrAS_DD", "mxrAS_DD");
function mxrAS_DD($filterByUser = false){
    /* So DD pulls in some parameters and figures out which dropdown we want.
    Originally built to handle AlphaStreams so we may try for generic
    but end up doing that first. */
    
    // Set the JSON header
    header("Content-type: text/json");
    //POST Vars sent by AJAX Request - Key one is the type of box needed.
    $ddType = $_POST['dd'];
    $ddName = $_POST['ddName'];

    //So we filterByUser if we want...
    $passedParams = array('ddName'=>$ddName,'showAfter'=>false);

    $streamChoice = $_POST['streamChoiceRadio'];
    
    switch ($ddType) { 
        case "streams":
            //We want an alphaStream so need so extra data

            if (isset($_POST['atypeListWrapper'])){
                $atype = $_POST['atypeListWrapper'];
            } else {
                $atype = ($streamChoice==5) ? 'OPTION' : 'ALL_ALL';
            }

            //Force $atype = 'ALL_ALL' for now..
            //$atype = 'ALL_ALL';

            $outputHtml = mxrAS_SQL_DDstreams($streamChoice, $ddName, true,$atype);
            $passedParams['streamChoiceRadio'] = $streamChoice;

            break;

        case "atypes":
            $streamChoice = $_POST['streamChoiceRadio'];
            $outputHtml = mxrAS_SQL_DD_assetTypeList($ddName, $filterByUser);
            $passedParams['streamChoiceRadio'] = $streamChoice;
            break;

        case "secIDList":
            //We want the list of instruments for our universe...not sure if this gets fired...

            if (isset($_POST['atypeListWrapper'])){
                $atype = $_POST['atypeListWrapper'];

            } else {
                $atype = 'ALL_ALL';
            }
            //$outputHtml = mxrAS_SQL_DDSecIDList($ddName,$checkUserCapabilities,$atype);
            $outputHtml = mxrAS_SQL_DDstreams(4, $ddName, $filterByUser,$atype);
            break;

        case 'xfxList':
            $outputHtml = mxrAS_SQL_DD_FXList($ddName, $filterByUser,'X-Currency',false);
            break;

        case "fxList" :
            $outputHtml = mxrAS_SQL_DD_FXList($ddName,$filterByUser,'Currency');
            break;

        case "weightList" :
            $outputHtml = mxrAS_SQL_DD_weightList($ddName,$filterByUser);
            break;

        case "group" :
            $outputHtml = mxrAS_SQL_DD_groupList($ddName,$filterByUser);
            break;

        case "periodicity" :
            $outputHtml = mxrAS_SQL_DD_periodList($ddName,$filterByUser);
            break;

        case "source" :
            $outputHtml = mxrAS_SQL_DD_sourceList($ddName,$filterByUser);
            break;

        case "atype" :
            $outputHtml = mxrAS_SQL_DD_assetTypeList($ddName,$filterByUser);
            break;

        case "calc" :
            $outputHtml = mxrAS_SQL_DD_calcList($ddName,$filterByUser);
            break;

        default:
            //Not sure if we can guess a default behaviour.
            $outputHtml = "<em>Error from server - check posted parameters...</em>";
    }

    if (isset($streamChoice)){
        $passedParams['showAfter']= ($streamChoice*1==4) ? true:false;
    }

    $passedParams['streamChoiceRadio'] = $streamChoice;

    $metaData = array('infoMsg'=>"Built the {$ddType} list.",
        'controlType'=>'dropdown',
        'astype'=>'success',
        'passedParams'=>$passedParams
    );

    //Send back to the calling $.getJSON request...
    echo (json_encode(array('meta'=> $metaData,'dropDown'=>$outputHtml)));
    die();

}