<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-08-25
 * Time: 3:00 PM
 */

/*Build a performance table */
add_action("wp_ajax_mxrAS_PTAB", "mxrAS_PTAB");
function mxrAS_PTAB(){
    //So PTAB grabs performance data for a given day from the batch and displays in a nice table.

    // Set the JSON header
    header("Content-type: text/json");

    //POST Vars sent By AJAX Request
    $radioDate = $_POST['snapshotDate'];
    $streamChoice = $_POST['streamChoiceRadio'];

    //Grabs the the pivot table output by default - and radioDate by reference to report back the actual date used.

    $outputArray=mxrAS_SQL_PTAB($radioDate,$streamChoice);


    //Build the table and messages
    $tableHtml = "<table id='mxrAS_PTAB_dataTable' class='mxrAS_dataTable display compact'>" . mxrAS_tableHeaderSimple($outputArray['colHeader']) . mxrAS_tableBodyArray($outputArray['table']) . "</table>";
    $infoMsg = $outputArray['colHeader'][0] . ' Performance Data Found: ' . count($outputArray['rowHeader']) . ' Streams For ' . $radioDate . '<br/>';

    //Build out the params
    $dTableParams = array('bJQueryUI'=> false,
        'bPaginate'=> false,
        'bFilter'=> true,
        'bSort'=> true,
        'sScrollY'=>"1000px",
        'aaSorting'=> array(array(9,'desc'),array(1,'desc'),array(2,'desc')),
        'dom'=>"T<'clear'>lfrtip",
        'tableTools'=>array('sSwfPath'=>"/swf/copy_csv_xls_pdf.swf")
    );

    //Build the table object...
    $table = array('divID'=>'mxrAS_PTAB_tableWrapper',
        'tDOM' => 'mxrAS_PTAB_dataTable',
        'data' =>$tableHtml,
        'msg'=>"<h4>{$infoMsg}</h4>",
        'dTableParams'=> $dTableParams
    );

    $pParams = array('snapshotDate'=>$radioDate,'streamChoiceRadio'=>$streamChoice);
    $metaData = mxrAS_HCMakeMeta('tableArray','',$pParams,'',0,$infoMsg);
    //Output the data
    echo (json_encode(array('meta'=> $metaData,'table'=>array($table))));
    die();

}


//Seem to have a problem here because it doesn't do scatter, but a line chart...
add_action('wp_ajax_mxrAS_RSCAT',"mxrAS_RSCAT");
function mxrAS_RSCAT(){
    //So we draw a scatter of the daily returns...
    //POST Vars sent By AJAX Request
    $streamChoice = $_POST['streamChoiceRadio'];
    $streamID = $_POST['streamListWrapper'];

    $scalar = 10000;
    $radioDate = $_POST['snapshotDate'];

    //You need to pull in the shifted amounts and the TE direct here - it seems like there's some repeated hits to the db
    //but you'd be keeping it generic.

    $perfTypeID = array(
        array('id'=>26,'scalar'=>$scalar,'color'=>"rgba(119, 152, 191, .5)",'desc'=>""),
        array('id'=>6,'scalar'=>$scalar/sqrt(260),'color'=>"rgb(30,180,30)",'desc'=>"1 Std Dev Up"),
        array('id'=>6,'scalar'=>2*$scalar/sqrt(260),'color'=>"rgb(30,210,30)",'desc'=>"2 Std Dev Up"),
        array('id'=>6,'scalar'=>-$scalar/sqrt(260),'color'=>"rgb(180,30,30)",'desc'=>"1 Std Dev Down"),
        array('id'=>6,'scalar'=>-2*$scalar/sqrt(260),'color'=>"rgb(210,30,30)",'desc'=>"2 Std Dev Down")
    ); //'1dayret',exante te
    //Go grab daily returns for this stream...
    //Send back to client.

    //Now it includes the TE bands...
    echo (json_encode(mxrAS_timeSeriesFromPerfTable($streamID,$streamChoice,$radioDate,$perfTypeID,'ScatterChart', 1, 1)));
    die;
}

//Performance Commands that all use a perf id from the perf tables...
add_action("wp_ajax_mxrAS_RAW", "mxrAS_RAW");
function mxrAS_RAW(){
    //Produce a chart for the RAW data stored in an instrument.

    echo json_encode(mxrAS_rawTimeSeriesFromRets($_POST['streamListWrapper'],4,$_POST['snapshotDate']));
    die();
}
add_action("wp_ajax_mxrAS_NAV", "mxrAS_NAV");
function mxrAS_NAV(){
    //Produce a line chart for NAV

    //Pick up the post-ed data
    $streamID = $_POST['streamListWrapper'];
    $streamChoice = $_POST['streamChoiceRadio'];
    $radioDate = $_POST['snapshotDate'];

    $perfTypeID = 27;//NAV
    if($streamChoice ==4){
        $perfTypeID=26;
    }

    //Send back to client.
    echo json_encode(mxrAS_timeSeriesFromPerfTable($streamID,$streamChoice,$radioDate,$perfTypeID));
    die();
}

add_action("wp_ajax_mxrAS_FHCP", "mxrAS_FHCP");
function mxrAS_FHCP($cleanVars = true){

    $mainTitles[]="Monthly % Performance";
    $mainTitles[]="Cumulative % Performance";

    mxrAS_PSAT($cleanVars, 'FHCP', false, $mainTitles);
    die();
}

add_action("wp_ajax_mxrAS_PSAT", "mxrAS_PSAT");
function mxrAS_PSAT($cleanVars=true, $postVerb = 'PSAT',$dualAxis = true, $mainTitle = ""){


    //Pick up the post-ed data
    //$myStreamFactory = new \AlphaSelect\StreamFactory();
    //$desiredReturnStream = $myStreamFactory->buildStreamFromParams($_POST['snapshotDate'], $_POST['streamListWrapper'], $_POST['streamChoiceRadio']);

    if($cleanVars){
       mxrAS_cleanPOSTvars();
    }

    //Knowing the WP user helpful - we will need a WP to PG user map.
    $userObj = wp_get_current_user();
    $radioDate = $_POST['snapshotDate'];

    $swapMsg = false;
    $streamID = $_POST['streamListWrapper'];

    
    if($postVerb == 'PSAT') {
        $streamChoice = $_POST['streamChoiceRadio'];
        $classDetails = array(
            'useMe' => false
        );
        
    } else {

        //So we need to ensure that we only offer up the right choices...
        //Funds and Dates

        $streamChoice = 5; //This is always the FieldHouse funds.
        $streamID = 9200;
        $swapMsg = true;

        //Got to get the managerComment - notice we will change the radioDate because we find the latest comment and hence the latest version. However
        //some users can see unsigned comments...
        
        $classDetails =  mxrAS_getPMDetails($streamID);
        $classDetails['managerComment'] = mxrAS_getManagerComment($streamID, $radioDate, $userObj);
        $bmkRatings = mxrAS_getRiskRatingAndBMK($streamID);
    }
    //Lets make a chart from it too... Mar 2014 - change for cumulative too
    $classDetails['pName'] = mxrAS_getPortfolioName($streamChoice, $streamID);

    //Aggregate the breakdown using the params agg?
    //1 is look up the aggregates from DB, 0 is don't bother, -1 is deduce them from the old positions.
    $aggData = -1;

    //Let's do a quick check of any data...
    //$hasHolds = mxrAS_hasHolds($desiredReturnStreamProperties->getTypeID(), $streamInputChoice->getStreamID(), $streamInputChoice->getSnapShotDate());

    $hasHolds = mxrAS_hasHolds($streamChoice, $streamID, $radioDate);

    $pParams = array('snapshotDate'=>$radioDate,'streamChoiceRadio'=>$streamChoice,'streamListWrapper'=>$streamID);

    if($hasHolds){
        //How do we chose the start date?
        //Monthly returns and monthly attribution but no stats.

        $retsArray = mxrAS_getMonthlyAttribution($radioDate, $streamChoice, $streamID, $aggData);
        //Why not just change the function to accept a streamInputChoice...
        //$retsArray = mxrAS_getMonthlyAttribution($streamInputChoice->getSnapShotDate(), $streamInputChoice->getTypeID(), $streamInputChoice->getStreamID());
        


        if ($mainTitle==""){
            //echo "Monthly Attribution Totals and Drilldown For {$classDetails['pName']}.";
            $mainTitle = "Monthly Attribution Totals and Drilldown For {$classDetails['pName']}.";

        }

        $charts = mxrAS_makeDrillDownAttChart($retsArray, array('main'=> array($mainTitle) , 'y'=>'% Return', 'x'=>'Date'), $dualAxis);

        //Lets make a table to display it all in...
        //$pParams = array('snapshotDate'=>$radioDate,'streamChoiceRadio'=>$streamChoice,'streamListWrapper'=>$streamID);

        $pOut = array(
            'meta'=>mxrAS_HCMakeMeta('chart_tableArray', 'chart', $pParams, $charts, $dualAxis ? 1:0 , "Found Data..."),
            'charts'=>$charts,
            'table'=>mxrAS_makePSATTableArray($retsArray, $streamChoice, $streamID, $classDetails['pName'], $postVerb),
            'tMsg' => '',
            'cDetails' => $classDetails
        );
       
        if($swapMsg){
            $temp = explode(' : ', $pOut['table'][1]['msg']);
            $pOut['tMsg'] = $temp[1];
            $pOut['table'][1]['msg'] = $temp[0];
        }


        echo(json_encode($pOut));

    } else {
        echo(json_encode(array('meta'=>mxrAS_HCMakeMeta('error','error',$pParams,[],1,"<h3>No Holdings Found For This Stream</h3>"))));
    }
    die();
}