<?php
/**
 * Created by PhpStorm.
 * User: NLaxton
 * Date: 15/04/2015
 * Time: 9:32 AM
 */

add_action("wp_ajax_mxrAS_TRSUM", "mxrAS_TRSUM");
function mxrAS_TRSUM(){
    //So we process the passed parameters and display the trade summary for each date.
    mxrAS_cleanPOSTvars();

    //Grab a summary of the trades for this view.
    $tradeSummary = new \AlphaSelect\TradeSummary($_POST['streamChoiceRadio'], $_POST['streamListWrapper']);
    $divID = "mxrAS_dtable";
    $tDOM = "mxrAS_TradeListSummaryTable";

    //So now we want this in a table.
    $outputTable = new AlphaSelect\Table(
        $tradeSummary->getTradeRowsForTable(),
        $divID,
        $tDOM,
        "Trade History Built for {$tradeSummary->getDeptName()} up to  {$_POST['snapshotDate']} : Found {$tradeSummary->getNTrades()} Trades Summaries."
    );

    //Adjust some of the data...
    //Now we set the meta Params
    $outputTable->setMeta('tableArray', [$_POST['snapshotDate'],  $_POST['streamChoiceRadio']]);
    $outputTable->masterSetupTable();

    echo json_encode($outputTable->getFullTable());
    die();
}


add_action("wp_ajax_mxrAS_HHOLDS", "mxrAS_HHOLDS");
function mxrAS_HHOLDS($cleanVars = true){
    mxrAS_cleanPOSTvars();

    //We pull in a full history of all positions.
    //Pretty much all we have is in the streamDetails
    if($cleanVars){
        mxrAS_cleanPOSTvars();
    }

    $streamID = $_POST['streamListWrapper'];
    $streamChoice = $_POST['streamChoiceRadio'];
    $radioDate = $_POST['snapshotDate'];

    //Aggregate the breakdown using the params agg?
    $userObj = wp_get_current_user();
    $aggData = true;

    $hasHolds = mxrAS_hasHolds($streamChoice,$streamID,$radioDate);

    $meta = mxrAS_HCMakeMeta('tableArray','tableArray', [], array(0), 1, "");
   if($hasHolds){
        //Get the holdings history.
       $stream = new \AlphaSelect\StreamDetails($streamChoice);
       $SQL = implode(" {$streamID} ", $stream->getHistoricalHoldingsSQL());

       $holdsHistory = mxrAS_db_grabRows('AS', $SQL, true);
       $depName = mxrAS_getPortfolioName($streamChoice, $streamID);

       $outputTable = new \AlphaSelect\Table(
           $holdsHistory,
           "mxrAS_dtableSingle",
           "mxrAS_HoldingHistoryTable",
           "Holding History Built for " . $depName
       );

       //Now we set the meta Params
       $outputTable->setMeta('tableArray', [$_POST['snapshotDate'],  $_POST['streamChoiceRadio']]);

       //Set the cols (we go for all of them);
       $outputTable->setCols([
           'applicable_date'=>'Holding Date',
           'timestamp'=>'Time Stamp',
           'asset_type'=>'Class',
           'strategy'=>'Sub-Strategy',
           'asset_name'=>'Security',
           'model_weight'=>'Amount %'
       ]);


       $meta['rationaleMsg'] = "<h4>Historical Holdings Shown For {$depName}</h4>";

       //Set the table params


       $outputTable->setDataTableParams(
           array('bJQueryUI'=> false,
               'bPaginate'=> false,
               'bFilter'=> false,
               'bInfo'=>false,
               'bSort'=> true,
               'sScrollY'=>"1000px",
               'bRetrieve'=> true,
               "dom"=> "Tlfrtip",
               'oTableTools'=>array('sSwfPath'=>plugin_dir_url(__FILE__) . 'js/DataTables-1.9.4/extras/TableTools/media/swf/copy_csv_xls_pdf.swf')
           )
       );
       $tableTrade = $outputTable->getFullTable();
       $output = array(
           'meta'=>$meta,
           'table'=> $tableTrade['table']
       );


    } else {
       $output = array(
           'meta'=>$meta,
           'table'=> ""
       );
   }

    echo(json_encode($output));
    die();
}

add_action("wp_ajax_mxrAS_TRDET", "mxrAS_TRDET");
function mxrAS_TRDET(){
    mxrAS_cleanPOSTvars();

    //We pull in the summary of the trade (plus a chart) of the trade.
    //I want before - after - trade.

    //For models and signals the view_id is a ts.
    $newTradeDetails = new \AlphaSelect\TradeDetails($_POST['view_id'], $_POST['streamListWrapper'], $_POST['streamChoiceRadio']);
    $rawChart = $newTradeDetails->createChart();

    $depName = $newTradeDetails->getDeptName();

    //Sort out the tables
    $divID = 'mxrAS_tradeTableDiv';
    $tDOM = 'mxrAS_tradeTable';

    $outputTable = new \AlphaSelect\Table(
        $newTradeDetails->getTradeRowsForTable(),
        "mxrAS_dtableSingle",
        "mxrAS_TradeListSingleTable",
        "Trade History Built for {$depName}");

    //Adjust some of the data...
    //Now we set the meta Params
    $outputTable->setMeta('tableArray', [$_POST['snapshotDate'],  $_POST['streamChoiceRadio']]);

    //Set the cols (we go for all of them);
    $outputTable->setCols([
        'asset_name'=>'Asset',
        'model_weight'=>'Amount %',
        'close'=>'Close Price',
        'stopFill'=>'Fill Price'
    ]);

    $meta = mxrAS_HCMakeMeta('chart_tableArray','chart', [], array(0), 1, "");
    $meta['rationaleMsg'] = "<h4>Trades Shown For {$depName}</h4><div class='gray-box'>Rationale : " . $newTradeDetails->getRationale() . "</div>";

    $tableTrade = $outputTable->getFullTable();
    $output = array(
        'meta'=>$meta,
        'charts'=>array($rawChart),
        'table'=> $tableTrade['table']
    );
    echo(json_encode($output));
    die();
}