<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-08-19
 * Time: 1:55 PM
 */

add_action("wp_ajax_mxrAS_KWL","mxrAS_KWL");
function mxrAS_KWL($cleanVars = true){
    //First thing we do is change the db record to be marked as kill.

    if($cleanVars){
        mxrAS_cleanPOSTvars();
    }

    /*$streamChoice = $_POST['streamChoiceRadio'];
	$streamID = $_POST['streamListWrapper'];
	$radioDate = $_POST['snapshotDate'];
	*/

    //Call the line of SQL to update the db - for now we kill the whole watch list...
    //It will kill all the watches upto and including the radioDate.
    $preMsg = mxrAS_SQL_KWL($_POST['streamChoiceRadio'],$_POST['streamListWrapper'],'K',$_POST['snapshotDate']);

    //We should make a user param to do soft watch
    /*$softWatch = true;
    $wListArray = mxrAS_getWatchListCore($streamChoice,$streamID,$radioDate,$softWatch,$preMsg);

    echo(json_encode(mxrAS_buildWatchListTable($wListArray,$preMsg,$streamID)));
    */
    mxrAS_WLT(false, $preMsg);
    die();
}

add_action("wp_ajax_mxrAS_WLT", "mxrAS_WLT");
function mxrAS_WLT($cleanVars = true, $preMsg = ""){
    if($cleanVars){
        mxrAS_cleanPOSTvars();
    }
    //Brings up a WatchList for A Current Position.
    //We should make a user param to do soft watch
    $softWatch = true;
    $wListArray = mxrAS_getWatchListCore($_POST['streamChoiceRadio'], $_POST['streamListWrapper'], $_POST['snapshotDate'], $softWatch, $preMsg);

    //OK the wListArray is manipulated in buildWatchListTable
    echo(json_encode(mxrAS_buildWatchListTable($wListArray, $preMsg, $_POST['streamListWrapper'], mxrAS_hasStopsTriggers($_POST['streamChoiceRadio'], $_POST['streamListWrapper']))));
    die();

}

add_action("wp_ajax_mxrAS_SWL", "mxrAS_SWL");
function mxrAS_SWL(){

    //Check a user can save to this view...
    //Need the current user, send that to the PG db and check - if yes then carry on otherwise you
    //Simply recalc...


    //So we pull in the edited data...
    //Get db stored data to produce the unedited watch list -- This helps avoid position rounding in the table that doesn't actually exist...
    $streamID = $_POST['streamListWrapper'];
    $streamChoice = $_POST['streamChoiceRadio'];
    //This looks messy but actually lets us get the 'right data' client side and reuse code on the server...
    $buttonVarName = $_POST['b'];
    $wlEdits = $_POST[$buttonVarName];
    $softWatch=true;

    //1 have BackDate = TRUE AND have the role or capability "can back date".&& current_user_can('backdatetrades')==1)
    if ($_POST['backdatechk'] == 1){
        $radioDate = $_POST['snapshotDate'];
    } else {
        $radioDate = date_format(date_create("now"), 'Y-m-d');
    }

    //TODO Make sure this works if we sent NO DATA
    echo(json_encode(mxrAS_setWatchListCore($streamID,$streamChoice,$wlEdits,$softWatch,"",$radioDate)));
    die();
}

add_action("wp_ajax_mxrAS_TWL", "mxrAS_TWL");
function mxrAS_TWL(){

    //Check a user can save to this view...
    //Need the current user, send that to the PG db and check - if yes then carry on otherwise you

    //Step 1 - We first save the watchList we've been given and set tradeMode as true...
    $streamID = $_POST['streamListWrapper'];
    $streamChoice = $_POST['streamChoiceRadio'];
    $radioDate = $_POST['snapshotDate'];

    //This looks messy but actually lets us get the 'right data' client side and reuse code on the server...
    $buttonVarName = $_POST['b'];

    $wlEdits = $_POST[$buttonVarName];
    $softWatch=true;

    $rationale = $_POST['rationale'];

    //Trade WatchList allows for backdated trades - ideal to set up new views...
    //However you need to do 2 things
    //1 have BackDate = TRUE AND have the role or capability "can back date".&& current_user_can('backdatetrades')==1)
    if (!isset($_POST['backdatechk'])) {
        $radioDate = date_format(date_create("now"), 'Y-m-d');
    } else {
        $radioDate = ($_POST['backdatechk']==1)  ?  $radioDate : date_format(date_create("now"), 'Y-m-d');
    }

    //Make sure this works if we sentWL NO DATA
    $savedWatchListTable = mxrAS_setWatchListCore($streamID,$streamChoice,$wlEdits,$softWatch,$rationale,$radioDate);

    //Now we go get everything
    $wListArray = mxrAS_getWatchListCore($streamChoice,$streamID,$radioDate,$softWatch,"");

    //And then do a TRADE...Then trade the holdings - 2 db calls as 2 tables to populate... So calls 3 & 4.
    $msg = mxrAS_tradeWatchList($wListArray,$streamChoice,$streamID,$radioDate,$rationale);

    //Now kill the watch list - quite intensive all this but we plod through...
    $killMsg = mxrAS_SQL_KWL($streamChoice,$streamID,'K',$radioDate);

    //Go get the list again now we have traded everything.
    $wListArray = mxrAS_getWatchListCore($streamChoice,$streamID,$radioDate,$softWatch,"");

    echo(json_encode(mxrAS_buildWatchListTable($wListArray,$msg . "|" . $killMsg,$streamID)));
    die();
}

add_action("wp_ajax_mxrAS_UWL", "mxrAS_UWL");
function mxrAS_UWL(){
    /* So we need the stream ID and the stream Type to grab the data in the db.
    This provides us with the data we need to inject in the new watch list paired with the sec ID. We do this because our
    actual watchlist and positions may be more precise than 1bp which is the tolerance on the screen.
    */

    //Get db stored data to produce the unedited watch list -- This helps avoid position rounding in the table that doesn't actually exist...
    $streamID = $_POST['streamListWrapper'];
    $streamChoice = $_POST['streamChoiceRadio'];

    //This looks messy but actually lets us get the 'right data' client side and reuse code on the server...
    $buttonVarName = $_POST['b'];
    $wlEdits = $_POST[$buttonVarName];

    //What's the date?
    $radioDate = $_POST['snapshotDate'];
    //Update the formats...
    mxrAS_viewFormatter($wlEdits, 'wlEdits', 1);
    $wListArray = mxrAS_prepareWatchListData("mxrAS_updated", $streamID, $streamChoice, true, $wlEdits, $radioDate);

    echo(json_encode(mxrAS_buildWatchListTable($wListArray, "", $streamID)));
    die();
}