<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-05-22
 * Time: 1:55 PM
 *
 * RiskMatrices is an array that has IDs in the matrix
 *
 * Going forward a riskMatrix should be made totally on the fly.
 * That is - riskIDs, dates,
 */

namespace AlphaSelect;


class RiskMatrix {

    public $riskMatrix;
    public $success = false;

    private $riskIDs;
    private $targetRiskDate;
    private $riskDate;

    public function __construct($targetDate, $myIDArray){
        //Set the IDs.
        $this->setupRiskMatrix($targetDate,$myIDArray);
    }

    public function getRiskIDs(){
        //Send back the array of riskIDs.
        return $this->riskIDs;
    }

    public function setRiskIDs($myIDArray){
        //Set the riskID array
        $this->riskIDs = $myIDArray;

        //Which prompts a recollection of the matrix.
        $this->buildMatrix();

    }

    /*  The TargetDate is the one we would like, but didn't necessarily get from
        retrieval process.
    */
    public function getTargetDate(){
        return $this->targetRiskDate;
    }
    public function setTargetDate($myDate){
        $this->targetRiskDate = $myDate;

        //Recollect the data
        $this->buildMatrix();

    }

    /*  There is no way to manually set a riskDate - other than what is sent with the data
        But you can get it...
    */
    public function getRiskDate(){
        return $this->riskDate;
    }

    private function getSQL(){

        return "WITH idTable AS (
					    SELECT DISTINCT i.asset_id as secid1
					    FROM ccp_instruments i
					    WHERE i.asset_id IN (" . implode(',', $this->riskIDs) . "))

				    SELECT r.applicable_date as rdate, r.secid1, r.secid2, r.var
	                FROM ccp_exantecovar r

                    JOIN idTable id1 ON r.secid1 = id1.secid1
					JOIN idTable id2 ON r.secid2 = id2.secid1
	                WHERE r.applicable_date =
	                    (   SELECT MAX(d.applicable_date)
	          			    FROM ccp_exantecovar d
	          		        WHERE d.applicable_date <= '" . $this->targetRiskDate . "')

	                ORDER BY r.secid1,r.secid2";

    }

    private function buildMatrix(){
        //Collects the data using the date and IDs.
        $rows = mxrAS_db_grabRows('AS',$this->getSQL,false);

        //Initialise the riskMatrix.
        $this->riskMatrix = array();
        $this->success = false;

        if (count($rows)>0) {
            $this->riskDate = $rows[0][0];

            // And build the risk matrix using the asset ids as keys...
            foreach($rows as $r){
                $id1=(string)$r[1];
                $id2=(string)$r[2];

                $this->riskMatrix[$id1][$id2]=$r[3];

                // Copies into lower echelon - we could just do it and have some duplicated copying
                // instead of the if statement. Not sure if N if statements quicker than N copies.
                if ($r[1]<$r[2]){
                    $this->riskMatrix[$id2][$id1]=$r[3];
                }
            }

            //We did something?
            $this->success = true;
        }
    }

    private function setUpRiskMatrix($targetDate, $myIDArray){

        //Set the SQL up
        $this->riskSQL = self::
        $this->targetRiskDate = $targetDate;
        $this->setRiskIDs($myIDArray);

    }




} 