<?php
/**
 * Created by PhpStorm.
 * User: nicklaxton
 * Date: 2014-09-02
 * Time: 1:37 PM
 */


/*StopDetails are a list of securities, and the stop/drawdown weights
which are associated with a Stop.
We may make this an abstract class and then use a stopdetails in the Stop class...
*/

namespace AlphaSelect;


class StopDetails {

    public $detailsList;
    //Is an array of stopDetailSingles.
    function __construct($stopID){
        if($stopID>0){
            //Build the array of stopDetails
            $this->populateDetailsList($stopID);
        }
    }

    public function getDetailsList(){
        return $this->detailsList;
    }

    public function getDetailsListInArrayForOutput(){
        $outArray = [];
        foreach($this->detailsList as $row){
            $outArray[] = array('secID'=>$row->getAssetID(), 'sAmt'=>$row->getStopAmount(), 'sPrice'=>$row->getStopPrice(), 'gLike'=>$row->getGroupLikeString(), 'adj'=>$row->getAdjustment());
        }
        return $outArray;
    }

    public function add2List($singleDetail){
        $this->detailsList[] = $singleDetail;
    }

    private function populateDetailsList($stopID){
        $SQL = "select det.asset_id, i.asset_name, det.stopamount, det.stopprice,d.adjustment
                from ccp_stops_details det
                join ccp_instruments i on det.asset_id = i.asset_id
                where det.stop_id = {$stopID}";

        $rows = mxrAS_db_grabRows('AS', $SQL, false);
        foreach($rows as $r){
            $newDetail = new StopDetailSingle($r['asset_id'],$r['name'],$r['stopamount'], $r['stopprice'], $r['adjustment']);
            $this->add2List($newDetail);
        }
    }


}

