<?php
/**
 * Created by PhpStorm.
 * User: NLaxton
 * Date: 25/03/2015
 * Time: 3:28 PM
 */

namespace AlphaSelect;


class TradeSummary {
//Class handles a simple list of all trades summary for a given Dept. or set of depts.
// //We could have a list of trades for a given view, views or all trades on
// a given date - or we could have more complex searches later.
    private $tradeSummaryList;
    private $dept_id;
    private $listSQL;
    private $streamDetails;
    private $tradeRowsForTable;
    private $deptName;
    private $rowLimit;

    function __construct($stype_id, $dept_id, $rowLimit = 0){
        $this->dept_id = $dept_id;
        $this->streamDetails = new StreamDetails($stype_id);
        $this->setRowLimit($rowLimit);//We have to set this before the setListSQL - poor design?
        $this->setListSQL();
        $this->setDeptName();
        $this->setSummaryList();

    }

    public function setRowLimit($r){
        $this->rowLimit = $r;
    }

    public function getRL(){
        return $this->rowLimit;
    }

    public function getNTrades(){
        return count($this->tradeRowsForTable);
    }

    public function getSummaryList(){

        $tempArray = array();
        foreach($this->tradeRowsForTable as $tradeRow){
            $tempArray[] = new TradeRow($tradeRow);
        }

        return $tempArray;
    }

    public function getTradeRowsForTable(){
        //Need to add the html button...

        //If we are looking at a View then attach the ViewID.
        //Else we should attach the timestamp...

        if ($this->streamDetails->getAlias()=='View'){
            $viewIDKey = 'view_id';
        } else {
            $viewIDKey = 'timestamp';
        }
        $output = [];
        foreach($this->tradeRowsForTable as $key=>$tradeRow){
            $tradeRow['editview'] = "<button class='mxrAS_ajaxlinks' onclick = 'mxrAS_AjaxLinkClick'
            mxrAS_ajaxURL='mxrAS_TRDET' mxrAS_hideParams = 'mxrAS_dtable' mxrAS_showParams = 'mxrAS_chartWrapper' mxrAS_params='streamChoiceRadio streamListWrapper snapshotDate'
            mxrAS_XP='b-TRDET view_id-{$tradeRow[$viewIDKey]}'>View</button>";

            $output[] = $tradeRow;
        }

        return $output;
    }

    public function getDeptName(){
        return $this->deptName;
    }

    public function setSummaryList(){
       $this->tradeRowsForTable = mxrAS_db_grabRows('AS', $this->getListSQL(), true);
    }

    private function setDeptName(){
        $key = $this->streamDetails->getDeptName();

        $tempSQL = "select {$key} from {$this->streamDetails->getStratTable()} where {$this->streamDetails->getDeptNameID()} = {$this->dept_id}";
        $deptName = mxrAS_db_grabRows('AS', $tempSQL,true);

        $this->deptName = $deptName[0][$key];
    }

    public function getDeptID(){
        return $this->dept_id;
    }

    public function getListSQL(){
        return $this->listSQL;
    }

    private function setListSQL(){
        //Only views have the view_id arrangement.
        if ($this->streamDetails->getAlias() == 'View'){
            $selectView = "H.view_id";
            $rationale = "H.rationale";
            $bool = true;
        } else {
            $selectView = "DISTINCT ON (H.timestamp) 0 as view_id";
            $rationale = "'Latest Trades' as rationale";
            $bool = false;
        }

        $this->listSQL = $this->getSQLForView($selectView, $rationale, $bool);

    }

    private function getSQLForView($selectView,$rationale,$bool){

       // $dept_IDValue = $this->streamDetails->getDeptNameID();

        $dept_idName = $this->streamDetails->getDeptIDName();
        $dept_FieldName = $this->streamDetails->getDeptFieldName();

        $tempSQL = "SELECT {$selectView}, H.{$dept_idName}, S.{$dept_FieldName},
            substring(H.timestamp from 1 for 4)||'-'||substring(H.timestamp from 5 for 2)||'-'||substring(H.timestamp from 7 for 2) as tradedate,
            H.timestamp, {$rationale}, 'editview' as editview
            FROM " . $this->streamDetails->getStratHoldsTables($bool) . " H
            JOIN " . $this->streamDetails->getStratTable() . " S ON S.{$dept_idName} = H.{$dept_idName}
            WHERE S.{$dept_idName} = " . $this->dept_id . " ORDER BY H.timestamp desc";

        if ($this->rowLimit > 0) {
            $tempSQL = $tempSQL . " limit " . $this->rowLimit . ";";
        }

        return $tempSQL;
    }



}