<?php
/***************************************************
* Data Processing and Control Library
* mxr AlphaSelect 2022
****************************************************/

function mxrAS_cleanPOSTvars(){
    foreach($_POST as $key=>&$value){
        if(is_array($value)){
            foreach($value as $akey=>&$avalue){
                if(is_string($avalue)){
                    $avalue = htmlentities($avalue);
                }
            }
        } else {
            if(is_string($value)){
            $value = htmlentities($value);
            }
        }
    }
}

function mxrAS_db_connect($shortDbName){
	//Figure out the connection parameters based on the shortName provided.
	switch($shortDbName){
		case "fxp":
			//Key values.
			$connStr='pgsql:host=localhost port=5432 dbname=marketxr_FXPilot';
			$user='marketxr_fxpWeb';
			$password='[fxp@b0y]';			
			break;
			
		case "AS":
			//Default values...
	        $connStr='pgsql:host=127.0.0.1 port=5432 dbname=aoawlqmy_alphapro';
			$user='aoawlqmy_asWeb';
			$password='[AS@nfl1971]';

			break;


	}

    try {
 	        $pdo = new PDO($connStr,$user,$password);
    }
    catch(PDOException $e) {
        echo $e->getMessage();
    }

    return $pdo;

}


function mxrAS_db_grabRows($dbName, $sql,$assocFlag=false)
{
    $sendFlag = $assocFlag ? "ASSOC" : "NO";
    return mxrAS_db_grabRowsWithAssoc($dbName, $sql, $sendFlag);
}

function mxrAS_db_grabRowsWithAssoc($dbName, $sql, $assocFlag = "NO"){

	//Just connects, executes and kills a db conn.
	$pgDb = mxrAS_db_connect($dbName);

	$pgQuery = $pgDb->query($sql);
	
	switch($assocFlag){
        case "ASSOC":
            $rows = $pgQuery->fetchAll(PDO::FETCH_ASSOC);
            break;
        case "NO":
            $rows = $pgQuery->fetchAll();
            break;
        case "COL0":
            //gets the first column
            $rows = $pgQuery->fetchColumn(0);
            break;
    }

	$pgDb = null;
	
	if($rows===false){
		$msg = "No records found for the query";
		$success = false;
	} else {
		$msg = "Success";
		$success = true;
	}
	return $rows;
}

function mxrAS_placeHolders($ph,$count=0,$tok=","){
	$r = array();
    if($count > 0){
        for($x=0; $x<$count; $x++){
            $r[] = $ph;
        }
    }
    return implode($tok,$r);
}
function mxrAS_getRadioDate($tsFlag=0,$now="now",$e=false){
	//So we can use this to back date something. 
	
	//Timestamp should use $now +time
	$d = new Datetime ($now);
	
	if($tsFlag==1){
		$date = $d->format('Ymd') . "-" . date("His",time());
	} else {
		$date=$d->format('Y-m-d');
	}
	return $date;
}
function mxrAS_setUpStreamParams($sType,$baseFX,$perfDate,$displayName,$desc,$location,$whichWeights){
	switch($sType){
		case 2:
			$pName = array('cashCon'=>array("null",0,1),
				   'horizon'=>array("null",30,1),
				   'isLive'=>array("null",1,1),
				   'laserGuide'=>array("null",1,1),
				   'production'=>array("null",1,1),
				   'scaleType'=>array("'H'","null",0),
				   'signalType'=>array("'AA'","null",0),
				   'tradeFutures'=>array("null",1,1),
				   'tcFactor'=>array("null",0,1),
				   'basePerspective'=>array("'{$baseFX}'","null",0),
				   'perfAttributionSt'=>array("'{$perfDate}'","null",0)
				   );
		break;
		
		case 1:
			$pName = array('accountType'=>array("'PAPER'",0,0),
						   'clientName'=>array("'{$displayName}'","null",0),
						   'dropExcludedAssets'=>array("null",1,1),
						   'minPositionSize'=>array("null",0,1),
						   'homeCurrency'=>array("'{$baseFX}'","null",0),
						   'grossLimit'=>array("null","null",1),
						   'rebalanceHorizon'=>array("null",7,1),
						   'tradeFutures'=>array("null",1,1),
						   'tcostScaling'=>array("'Risk Allocation'",0,1),
						   'liquidityCons'=>array("null",0,1),
						   'nominalValue'=>array("null","null",1),
						   'reportDescription'=>array("'{$desc}'","null",1),
						   'sameSideCons'=>array("null",0,1),
						   'location'=>array("'{$location}'","null",0),
						   'riskThreshold'=>array("null",0,1),
						   'alphaThreshold'=>array("null",0,1),
						   'whichWeights'=>array("'{$whichWeights}'",0,0),
						   'oldTE'=>array("null",0.01,1),
						   'tcFactor'=>array("null",0,1),
						   'NOPT'=>array("'Simple Merged'",0,0),
						   'tcFactor'=>array("null",0,1),
				   		   'perfAttributionSt'=>array("'{$perfDate}'","null",0)
				   );
		break;
	}
	return $pName;
}	
function mxrAS_AddNewStream($streamChoice,$baseFX,$displayName,$shortName,$perfDate,$location,$desc,$whichWeights){
	$streamDetails = mxrAS_getStreamDetails($streamChoice);
	
	$fieldName = $streamDetails['fieldName'];
	$tabName = $streamDetails['tableNameRoot'];
	$rows = mxrAS_db_grabRows('AS',"SELECT MAX({$fieldName}_id) FROM ccp_{$tabName}");
	$newID = $rows[0][0]+1;
	
	//Step 1 - set up the overview table...
	$user = "nick.laxton";
	$setupSQL = "INSERT INTO ccp_{$tabName} VALUES ({$newID},'{$displayName}'";
	
	//Nuances of the different tables
	if($streamChoice==2){
		$extra1 = ",'Y',";
		$extra2 = ",'L',";
		$extra3 = ",'{$desc}'";
	} else {
		$extra1 = ",'{$desc}','Y','Y',";
		$extra2 = ",";
		$extra3 = "";
	}
	
	$setupSQL .= $extra1 . "'{$shortName}','" . mxrAS_getRadioDate() . "','{$user}'" .$extra2 ."'{$baseFX}','{$perfDate}','{$location}'" . $extra3 . ")";
	
	//Step 2 - set up the params SQL - 
	$pName = mxrAS_setUpStreamParams($streamChoice,$baseFX,$perfDate,$displayName,$desc,$location,$whichWeights);
				   
	//Now combine these
	$vSQL = array();
	foreach($pName as $k=>$v){
		$vSQL[]="('2000-01-01','{$shortName}','{$k}'," . implode(",",$v) . ",{$newID})";
	}
	$paramSQL = "INSERT INTO ccp_{$tabName}_params VALUES " . implode(",",$vSQL);

	//Execute the SQL 
	$pgDb = mxrAS_db_connect('AS');
	
	//The new strategy/portfolio
	$pgQuery = $pgDb->prepare($setupSQL);
	$pgQuery->execute();
	
	//The new set of parameters...
	$pgQuery = $pgDb->prepare($paramSQL);
	$pgQuery->execute();
	
	return "Inserted the new Alpha-Stream {$displayName} and associated parameters.";
}

/**********************************************************
* SQL CMD Respository 										  *
***********************************************************/
function mxrAS_SQL_PTAB(&$radioDate,$streamChoice,$pivots=true){
	
	//This tallies with the sql statement - you can't change one without the other. 
	$keyColsPivots=array('pivotCol'=>4,'pivotRow'=>1,'valueCol'=>5,'formatCol'=>7);
	
	//Which set of tables?
	$streamDetails = mxrAS_getStreamDetails($streamChoice);
	
	//Pulls off the performance data for a given date and ptype - we may wish to alter the db schema
	//Refactor the perf_types table with a pid and then introduce a perf_types_groups with 'group and pid' - joining pid-pid with where group=x 
	//to produce the right join below. 
	$mySQL = "SELECT p." . $streamDetails['fieldName'] . "_id,t." . $streamDetails['fieldName'] . "_name as " . $streamDetails['alias'] . ",
				t.date_created,t.base_perspective,pt.type_description,p.value,p.applicable_date,pt.type_format 
				FROM ccp_" . $streamDetails['tableNameRoot'] . "_perf as p 
				INNER JOIN ccp_" . $streamDetails['tableNameRoot'] . " as t ON p." . $streamDetails['fieldName'] . "_id=t." . $streamDetails['fieldName'] . "_id 
				INNER JOIN ccp_perf_types as pt ON p.type=pt.ptype 
				WHERE p.applicable_date=(
					SELECT max(applicable_date) 
					FROM ccp_" . $streamDetails['tableNameRoot'] . "_perf 
					WHERE applicable_date<='" . $radioDate . "') AND pt.sort_order!=0 
				ORDER BY p." . $streamDetails['fieldName'] . "_id,pt.sort_order";
	
	//Grab the connection and run the query to grab the data...
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);
	
	//Put the radioDate back into a Jquery Format and the date pulled out of the system.
	$radioDate=$rows[0][6];

	//Do the pivot table if requested.
	if($pivots){
		$rows=mxrAS_groupArrayResults($rows,$keyColsPivots,$streamDetails);
	}
	
	return $rows;
}
function mxrAS_SQL_HTE(&$radioDate,$streamChoice,$streamID){
	
	//Figure out which stream we need.
	$streamDetails = mxrAS_getStreamDetails($streamChoice);
	
	//Fix the type token
	$tok = 'TE';
	
	//Build the SQL statement to pull off the tracking error
	$mySQL = "SELECT p.applicable_date, p.value 
			  FROM ccp_" . $streamDetails['tableNameRoot'] . "_perf as p 
			  WHERE p." . $streamDetails['fieldName'] . "_id = " . $streamID . " 
			  	AND p.type = '" . $tok . "' AND p.applicable_date>='" . $radioDate . "' 
			  ORDER BY p.applicable_date ASC";
	
	//necessary for the dateTime format of the charts to display timeSeries properly.
	date_default_timezone_set('UTC'); 
	
	//Make the database request for all the rows.
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);
	
	//Adjust the radioDate to the earliest date found. 
	$radioDate = $rows[0][0];
	
	//Bit time consuming as we already got the rows so could have done this on the fly...
	for($i=0;$i<count($rows);$i++){
		$newRows[]=array(strtotime($rows[$i][0])*1000,100*(double)(number_format($rows[$i][1],4)));
	}
	
	//Build the charts object.
	$jsCharts=array();
	
	$myCredits = mxrAS_HCGetCredits();
	
	$jsCharts[]=array(
		'chartOptions'=>array(
			'rangeSelector'=>array('selected'=>4),
		 	'title'=>array('text'=>'Historical Ex-Ante Risk'),
		 	'yAxis'=>array('title'=>array('text'=>'Risk %')),
		 	'credits'=>$myCredits,
		 	'exporting'=>mxrAS_HCGetExporting()
		 	),
		 'chartData'=>array ( 
			'data' => $newRows,
			'name' => 'Ex-Ante Risk',
			'id' => 'dataseries'
			)
		);
	  				  	 				
	//Prepare the data for output...
	return $jsCharts;
}
function mxrAS_SQL_CPOS(&$radioDate,$streamChoice,$streamID,$cType,$riskData,$sView = true){
	
	//This a little misleading as it can do marginals that need risk and weights. 
	$results = mxrAS_getPortfolioWeights($radioDate,$streamChoice,$streamID);
	$radioDate = $results['dDate'];
	
	// This is also a little misleading as the calcs are done in here...
	//Some work here started in getMC2R...TODO NFL Jul 2013
	
	return mxrAS_HCMakeMultiBarCharts($results,$cType,$riskData,$sView);
}
function mxrAS_SQL_HPOS(&$radioDate,$streamChoice,$streamID){
	
	//Figure out which stream we need but we don't grab cash lines.
	$streamDetails = mxrAS_getStreamDetails($streamChoice);
	
	$mySQL = "SELECT m." . $streamDetails['fieldName'] . "_name,i.asset_id, i.asset_name,h.applicable_date,h.value val 
			  FROM ccp_" . $streamDetails['tableNameHolds'] ." h
			  JOIN (
					SELECT k.asset_id,k.asset_name 
					FROM ccp_instruments k 
					JOIN (
						SELECT DISTINCT (asset_id) 
						FROM ccp_" . $streamDetails['tableNameHolds'] . "
						WHERE " . $streamDetails['fieldName'] . "_id=" . $streamID . " and applicable_date>='" . $radioDate . "'
						 AND asset_id <>207) as t ON k.asset_id=t.asset_id
					) i ON h.asset_id=i.asset_id
			 JOIN ccp_" . $streamDetails['tableNameRoot'] . " m ON h." . $streamDetails['fieldName'] . "_id=m." . $streamDetails['fieldName'] . "_id
			 WHERE m." . $streamDetails['fieldName'] . "_id=" . $streamID . " and h.value<>0 ORDER BY h.applicable_date;";
	//. $radioDate


	//necessary for the dateTime format of the charts to display timeSeries properly.
	date_default_timezone_set('UTC'); 
	
	//Make the database request for all the rows.
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);

	//Adjust the radioDate to the earliest date found - so HPOS is on and after...
	//So we have all the asset_ids and positions....
	$radioDate=$rows[0][3];
	$jsCharts=array();
	
	//Bit time consuming as we already got the rows so could have done this on the fly...
	//Anyway we break up the results into by asset_id arrays.

	$panelData=array();
	$panelSeries = array();
	$yAxis=array();
	for($i=0;$i<count($rows);$i++) {
		$k = $rows[$i][2];
		$panelData[$k][] = array(strtotime($rows[$i][3]) * 1000, 100 * (double)(number_format($rows[$i][4], 4)));
	}

	//Now set up the chartArray.
	foreach ($panelData as $k=>$v){
		$panelSeries[]=array('type'=>'line','name'=>$k,'data'=>$v, 'tooltip'=>array('valueDecimals'=>2));
	}
	$myCredits = mxrAS_HCGetCredits();

	//The panel names and data identify series in the chart...
	$jsCharts[]=array(
		'chartOptions'=>array(
			'chart'=> array('alignTicks'=>false),
		 	'rangeSelector'=>array('selected'=>4),
		 	'title'=>array('text'=>'Historical ' . $rows[0][1] . ' Positions For ' . $rows[0][0]),
		 	'navigator'=>array('enabled'=>false),
			'legend'=>array('enabled'=>true),
		 	'credits'=>$myCredits,
		 	'exporting'=>mxrAS_HCGetExporting()
		 	),
		 'chartData'=>$panelSeries
		);
	  				  	 				
	//Prepare the data for output...
	return $jsCharts;			 				 
}

function mxrAS_grabParamFromStreamParams($streamChoice, $streamID, $perfParam, $text = true){

    if($text){
        $sDetails = mxrAS_getStreamDetails($streamChoice);
        $tagSQL = "from ccp_" .  $sDetails['tableNameRoot'] . "_params where param = '{$perfParam}' and " . $sDetails['fieldName'] . "_id = {$streamID} and textvalue<>'NO'";

        switch ($perfParam) {
            case 'perfAggGroup':
                $mySQL = "select trim(substring(textvalue from 1 for position('_' in textvalue)-1)) as d, substring(textvalue from position('_' in textvalue)+1) as n ";
                break;

            default:
                $mySQL = "select textvalue ";
                break;
        }
        $rows = mxrAS_db_grabRows('AS', $mySQL . $tagSQL, false);
    } else {
        $rows=[];
    }
    return $rows;
}

function mxrAS_getOldIDSInThisView($streamChoice, $streamID){
    $sDetails = mxrAS_getStreamDetails($streamChoice);
	$aggRows = [];

	if ($streamChoice<4) {
		//3 months ago...
		$ddate = new DateTime("-2 months");
		$recentDate = $ddate->format('Y-m-d');

		$mySQL = "with
                master as (
                select distinct(asset_id) from ccp_" . $sDetails['tableNameHolds'] . " where " .
			$sDetails['fieldName'] . "_id =     {$streamID}
                ),
                recent as (
                select distinct(asset_id) from ccp_" . $sDetails['tableNameHolds'] . " where " .
			$sDetails['fieldName'] . "_id  = {$streamID} and timestamp>'{$recentDate}'
                )
                select master.asset_id
                from master left join recent on master.asset_id = recent.asset_id
                where recent.asset_id is null";

		$rows = mxrAS_db_grabRows('AS', $mySQL, true);


		foreach ($rows as $r) {
			$aggRows['Older Positions'][] = $r['asset_id'];
		}
	}

    return $aggRows;
}

function mxrAS_getAggNames($streamChoice, $streamID,$oldDataFlag = false){
    //We simply won't bother if it's an instrument - there's only 1 value anyway.
    $aggRows = [];
    $xIDs = [];

    if($streamChoice < 4) {
        //Grab the agg rows.
        if ($oldDataFlag) {
            //We look at the live file and see which instruments don't have positions for several weeks.
            $aggRows = mxrAS_getOldIDSInThisView($streamChoice,$streamID);

        } else {
            //We look up some aggregation rules..
            $aggRowsRaw = mxrAS_grabParamFromStreamParams($streamChoice, $streamID, "perfAggGroup");

            foreach ($aggRowsRaw as $r) {
                $aggRows[$r['n']] = $r['d'];
            }

            $xIDs = mxrAS_getExcludeNames($streamChoice, $streamID);
        }
    }

    return array('aggRows'=>$aggRows, 'excludeIDs'=>$xIDs);
}

function mxrAS_getExcludeNames($streamChoice, $streamID){
    $output = [];
    if($streamChoice < 4){
        $xRaw = mxrAS_grabParamFromStreamParams($streamChoice, $streamID, "perfAggExclude");
        //Now look up the excluded asset ID
        if(count($xRaw)>0){
            $inx=[];
            foreach($xRaw as $x){
                $inx[] = "'{$x[0]}'";
            }

            $sql = "select asset_id as id from ccp_instruments where iaa_aid in ( " . implode(',', $inx) . ")";
            $xRows = mxrAS_db_grabRows('AS', $sql, true);

            //Convert the array
            $output = [];
            foreach($xRows as $xr){
                $output[] = $xr['id'];
            }
        }
    }
    return $output;

}
function mxrAS_getPerfStartDate($streamChoice,$streamID,$rDate){
	//We don't worry if it's an instrument
	if($streamChoice != 4){
	    //If 5 then a FHC NAV series, else do normal stuff.
		$dDates = ($streamChoice ==5) ? mxrAS_db_grabRows('AS', "select inception from fhc_classes where classID = {$streamID}", false) : mxrAS_grabParamFromStreamParams($streamChoice, $streamID, "perfAttributionSt", true);
		if(count($dDates)>0){
			//Use it as the start date
			$startDate = "{$dDates[0][0]}";
		} else {
			//Set it to be 5 years ago (relative to the rDate which is off form yyyy-mm-dd)
			$startDate = (substr($rDate,0,4)*1-5) . substr($rDate,4);
		}

	} else {
		$startDate = "2000-01-01";//streamChoice = 4 and instrument.
	}
	return $startDate;
}

function mxrAS_getSensibleStartDateFromRadioDate(&$radioDate){
    if ($radioDate==""){
        //Get today's date in a string format.
        $radioDate = (new DateTime())->format('Y-m-d');
    }

    $startDateArr = explode('-', $radioDate);
    if ($startDateArr[1] == 1){
        //It's Jan so we need to go back a year and reset to 12.
        $startDateArr[1] = 12;
        $startDateArr[0] += -1;
    } else {
        $startDateArr[1] += -1;
    }
    $startDateArr[2] = 1;

    return implode('-', $startDateArr);
}

function mxrAS_getRiskSQL($radioDate = ""){
    $riskDate = mxrAS_getSensibleStartDateFromRadioDate($radioDate);

    $riskSQL = "(SELECT Q.asset_id, COALESCE (P.risk, 0) as risk FROM ccp_instruments Q
                LEFT JOIN (
                            SELECT RISKRANKED.secid1 as secid, RISKRANKED.var2 as risk
                            FROM (
                                SELECT secid1, secid2, ROUND(sqrt(var)*10000)/100 as var2, rank() OVER (ORDER BY applicable_date DESC) as rank
                                FROM ccp_exantecovar
                                WHERE applicable_date>='{$riskDate}' AND applicable_date<='{$radioDate}' AND secid1 = secid2) AS RISKRANKED
                            WHERE RISKRANKED.rank = 1) as P on P.secid = Q.asset_id) AS Z
                          ON I.asset_id = Z.asset_id ";
    return $riskSQL;
}
function mxrAS_getDurationSQL($radioDate = ""){
    //This query requires a little work - for now we fudge the radio date...
    $durationDate = mxrAS_getSensibleStartDateFromRadioDate($radioDate);

    $durationSQL =  "(SELECT A.asset_id, COALESCE (X.dur, 1) as duration FROM ccp_instruments A
                      LEFT JOIN (
                        SELECT r1.asset_id, ranked.value as dur
                        FROM (
                                SELECT ts, series_id, value, rank() OVER (PARTITION BY series_id ORDER BY ts DESC) as rank
                                FROM rets_series_data
                                WHERE series_id IN (
                                    SELECT series_id FROM rets_series_desc where groups = 28 and source = 'dirdurs'
                                    )
                                AND ts>='{$durationDate}' AND ts<='{$radioDate}'
                             ) as ranked
                        JOIN rets_series_desc r2 ON ranked.series_id = r2.series_id
                        JOIN ccp_instruments r1 on r2.name = r1.iaa_aid
                        WHERE ranked.rank = 1
                        ) as X
                      ON X.asset_id = A.asset_id) AS Y ON I.asset_id = Y.asset_id ";

    return $durationSQL;
}

function mxrAS_getStopAddBackRets(){
    $mySQL = "WITH X as (
select r.series_id, r.ts,sum(r.value) over (order by ts) as cumsum
from rets_series_data r
where r.series_id in (
                select series_id from rets_series_desc d
                where d.name in
                                (select iaa_aid from ccp_instruments where asset_id = 99)
                and periodicity = 'D' )
and r.ts>='15-Jul-2014' )

select X.series_id, X.ts, 1*(-0.01 - X.cumsum) as addBackRet from X
join
 (select X.series_id, min(X.ts) as sdate from X where X.cumsum < -0.01 group by X.series_id) as Z
on Z.series_id = X.series_id
 where X.ts = Z.sdate";

}
function mxrAS_getPortfolioWeights($radioDate, $streamChoice, $streamID){
	
	//Useful SQL tokens.
	$tok1 = 'atype';
	$tok2 = 'aid';
	$tok3 = 'sid';

    //This query requires a little work - for now we fudge the radio date...
    $durationSQL = mxrAS_getDurationSQL($radioDate);

	//We should probably rebuild the streamDetails as a class...
	if ($streamChoice < 4){
		$streamDetails = mxrAS_getStreamDetails($streamChoice);
		
	
		//AND i.iaa_aid<>( m.base_perspective || '_USD_30DFWD')
		//Build the SQL statement to pull off the latest positions...Formatting happens here - we quote in bp...
		//MAy 2014 - Added rid as Risk ID. For now it's the same as the sec id. But when we 
		//inject deltas it gets changed. 
		
		$mySQL = "SELECT M." . $streamDetails['fieldName'] . "_name pid, H.applicable_date ddate, I.asset_type " . $tok1 . ",
	                 TRIM(LEADING I.asset_type FROM I.asset_name) aname, I.iaa_aid longId, H.value val, Y.duration,
	                 (CASE WHEN I.asset_type = 'Option' THEN 0 ELSE 1 END) as delta,
	                 I.asset_id as rid, I.asset_id as " . $tok2 . $streamDetails['subID'] . "
              	FROM ccp_" . $streamDetails['tableNameHolds'] . " as H
              	JOIN ccp_instruments as I ON I.asset_id = H.asset_id
              	JOIN {$durationSQL}
			  	JOIN ccp_" . $streamDetails['tableNameRoot'] . " as M
			  	ON M." . $streamDetails['fieldName'] . "_id = H. " . $streamDetails['fieldName'] . "_id " . $streamDetails['joinStratSQL'] . "
			  	WHERE H." . $streamDetails['fieldName'] . "_id = " . $streamID . "
			  	AND H.".$streamDetails['dateName'] . " = (
						SELECT MAX(" .$streamDetails['dateName'] . ") 
						FROM ccp_" . $streamDetails['tableNameHolds'] . " 
						WHERE " . $streamDetails['fieldName'] . "_id = " . $streamID . " AND applicable_date <= '" . $radioDate . "')
				AND H.value<>0
				  ORDER BY I.asset_type, H.value ASC";

		//AND i.asset_type<>'Ratio Asset'  - test this...
	} else {
		//We grab an instrument...we could reduce this to one call - TODO. 
		$mySQL = "SELECT I.asset_name as pid, '{$radioDate}' as ddate, I.asset_type $tok1 , trim(leading I.asset_type from I.asset_name) aname,
		          I.iaa_aid longId, 1 as val, Y.duration, (CASE WHEN I.asset_type = 'Option' THEN 0 ELSE 1 END) as delta, I.asset_id as rid, I.asset_id as {$tok2}, -1 as {$tok3}, 'Underlying Asset'
		          FROM ccp_instruments as I
		          JOIN {$durationSQL}
		          WHERE I.asset_id = {$streamID}";
	}
		//Make the database request for all the rows.
		$rows = mxrAS_db_grabRows('AS',$mySQL,true);
	
		//We need to check if the db has actually returned anything here...
		if (count($rows) > 0){
			//We need to format the data here to nearest bp - does this actually do anything?
			foreach($rows as $k=>$r){
				$r[$k]['val'] = sprintf('%0.00',100*$rows[$k]['val']);
			} 
			//Adjust the radioDate to the earliest date found - note it's passed by reference.
			$radioDate = $rows[0]['ddate'];
	
			$outputArray = array ('pop' => true, 'pid'=>$rows[0]['pid'], 'dRows'=>$rows, 'dDate'=>$radioDate, 'dTypes'=>mxrAS_uniqueByKeyName($rows,$tok1), 'dTok'=>$tok1, 'dRiskIDs'=>mxrAS_uniqueByKeyName($rows,'rid'),'dStratIDs'=>mxrAS_uniqueByKeyName($rows,$tok3));
		
		} else {
			//Might break right now if we can't find the instrument for an instrument.
			$outputArray = array ('pop' => false,'pid'=>mxrAS_getPortfolioName($streamChoice,$streamID),'dRows'=>$rows,'dDate'=>$radioDate,'dTypes'=>array(),'dTok'=>$tok1,'dRiskIDs'=>array(),'dStratIDs'=>array());
		}
		
	//We now must handle delta = 0 instruments and figure out the actual deltas.
	//$outputArray is handled by reference.
	//There's a bit of a fudge here as we've already generated the unique risk ids, only to add potential duplicates so
	//we have to do isset tasks...

    mxrAS_injectRealDeltas($outputArray['dRows'], $outputArray['dDate'], $outputArray['dRiskIDs']);


    //Are they all zero?
    $outputArray['allZero'] = mxrAS_testIfAllThisValue($outputArray['dRows'], 'val', 0);
	return $outputArray;
}

function mxrAS_testIfAllThisValue($myArray, $key, $testVal=0){
        //We mainly use this to test for all zero positions in a set of weights...
        $success = true;
        //Filter the array for set values.
        foreach($myArray as $element){
            if($element[$key] != $testVal){
                $success = false;
                break; //quit the loop.
            }
        }
        return $success;
}

function mxrAS_injectRealDeltas(&$inResults, $rDate, &$riskIDs){
	
	//So this will change the risk ids for the nonDV01 securities.
	$aidArr = array();

	//Loop over the entire array
	foreach($inResults as $k=>$row){
        //Does it pass the filter test?
		if ($row['delta']==0){
            //Then we simply set up an option for this asset id.
            //For portfolios with lots of options we may wish to go grab all the data we need but for now it's one at a time.
            $tempOption = new AlphaSelect\Option($row['aid'], $rDate, $rDate);

            //grab the delta for the option.
            $inResults[$k]['delta'] = $tempOption->getRiskDelta($rDate);

            //And the underlying weights for the risk calculations
            $inResults[$k]['dv01Setup'] = $tempOption->getRiskIDWeights();

            //Keep track of those secIDs that were tinkered with
            $aidArr[] = $row['aid'];
        } else {
		    //We add an entry for the dv01Setup
            $inResults[$k]['dv01Setup'][$row['aid']] = 1;
		}
	}

    return $aidArr;
}

function mxrAS_getPerfLive($radioDate, $streamChoice, $streamID, $chartType = 'StockChart'){
	//So now we grab on the fly performance and put into an array just like the grab rows output...
}
function mxrAS_getTSeriesByTypeID($radioDate,$streamChoice,$streamID,$perfTypeID,$chartType='StockChart'){

	//So we can adapt here to instruments ----
	if ($streamChoice<4) {
		
		//Figure out which stream we need.
		$streamDetails = mxrAS_getStreamDetails($streamChoice);

		if ($perfTypeID<0){
			//We make ours on the fly.
			//We use the dailies from our other functions...

			//1 get a startdate (same as perfstartdate) have a func for that.
			$attArray = mxrAS_getStreamAttribution($startDate, $radioDate, $streamChoice, $streamID, $perfStartDate, $aggData);

		} else {

			//Build the SQL and import.
			$mySQL = "SELECT p.applicable_date, p.value, t.type_description, t.type_format, t.hcType, m." . $streamDetails['fieldName'] . "_name 
				  FROM ccp_" . $streamDetails['tableNameRoot'] . "_perf p
				  JOIN ccp_perf_types t on p.type = t.ptype 
			  	JOIN ccp_" . $streamDetails['tableNameRoot'] . " m  on p." . $streamDetails['fieldName'] . "_id = m." . $streamDetails['fieldName'] . "_id 
			  	WHERE p." . $streamDetails['fieldName'] . "_id = " . $streamID . " 
			  		AND t.pTypeID = " . $perfTypeID . " 
			  		AND p.applicable_date <= '" . $radioDate . "' 
			  	ORDER BY p.applicable_date";

			$dummyRows = mxrAS_db_grabRows('AS', $mySQL, false);
		}

	} else {
		//We are dealing with a single instrument...
		//So we actually need the SEC ID code...

	   $dummyRows = mxrAS_getTSeriesForSecID($radioDate,$streamID,$perfTypeID,5,$chartType);
	}
	return $dummyRows;
}


function mxrAS_rebaseRetsForNonUSDBasis($keyRets, $baseFXVector){

    if ($baseFXVector['usdID'] != $baseFXVector['proxyID']){
        //Alter the right indices...
        $proxyIDX = "{$baseFXVector['proxyID']}";
        $baseIDX =  "{$baseFXVector['usdID']}";

        foreach ($keyRets as $d=>&$retRow){

                $retRow[$baseIDX]= isset($retRow[$proxyIDX]) ? -$retRow[$proxyIDX] : 0;
            //    echo -$retRow[$proxyIDX] . ":" . $retRow[$baseIDX] . " -- ";
        }
    }
    return $keyRets;
}

function mxrAS_getMSeriesForStreamByAsset($startDate, $endDate, $streamChoice, $streamID){
	//So we pull in a query for several assets at once...
	$streamDetails = mxrAS_getStreamDetails($streamChoice);
	
	//Common SQL
	$joinSQL = "SELECT d.ts as ddate, i.asset_id as aid, d.value as ret FROM rets_series_data d 
						JOIN rets_series_desc des ON des.series_id = d.series_id 
						JOIN ccp_instruments i ON i.iaa_aid = des.name 
						WHERE i.asset_id ";
	
	$whereSQL = "AND d.ts>='" . $startDate . "' AND d.ts<='" . $endDate . "' 
						AND des.periodicity='D' AND des.groups=33
						ORDER BY d.ts,i.asset_id";

    $baseFXVector['usdID'] = 132;
    $baseFXVector['proxyID'] = 132;

	//Check the stream type and build the SQL 
	if($streamChoice<4){

        //Here we need to know the BaseFX and convert the USD_USD to BASE_USD
        //So we need to know what BASE_USD is and add in the code.
        $baseCCY = mxrAS_getBaseCcy($streamID,$streamChoice);
        $baseSQL = "";
        if ($baseCCY != 'USD'){
            $baseIDArray = mxrAS_db_grabRows('AS', "SELECT asset_id FROM ccp_instruments WHERE iaa_aid='{$baseCCY}_USD_30DFWD'", false);
            $baseID = $baseIDArray[0][0];
            $baseSQL = " UNION SELECT  {$baseID}";

            $baseFXVector['proxyID'] = $baseID;
        }

		//And the returns for each of the assets the view/portfolio/signal may have held during the period. 	
		$inSQL = "IN ( SELECT DISTINCT asset_id FROM ccp_" . $streamDetails['tableNameHolds'] . " h WHERE " . $streamDetails['fieldName'] . "_id = " . $streamID . " 
						AND applicable_date>='" . $startDate . "' AND applicable_date<='" . $endDate . "' " . $baseSQL . ") ";
	} else {
		//We are asked for an individual instrument...
		$inSQL = "= {$streamID} ";
	}
	
	//We don't fetchAll but fill one row at a time here...
    //echo ($joinSQL . $inSQL . $whereSQL);
    $rets = mxrAS_db_grabRows('AS', $joinSQL . $inSQL . $whereSQL, false);
	
	//Populate results...
	$keyRets = array();
	foreach($rets as $ret){
		$ddate = $ret['ddate'];
		$aid = $ret['aid'];
		
		$keyRets[$ddate][$aid]=$ret['ret'];
	}

    //This swaps the series for the baseFX for the proxy...
	return mxrAS_rebaseRetsForNonUSDBasis($keyRets, $baseFXVector);
}
function mxrAS_getLatestHoldings($startDate,$endDate,$streamChoice,$streamID,$earliest = true){
	//When we do performance attribution we often need the prevailing holdings that 
	//are live when the attribution starts...
	
	//If it's an instrument we don't need to check the holdings - we know it's 100% 
	if($streamChoice<4){
	
		//We are dealing with some viewVector so off we go...
	
		//If it's earliest then we look up the last set of holdings before the start date. 
		if($earliest){
			$streamDetails = mxrAS_getStreamDetails($streamChoice);
			$earlyDateSQL = "SELECT max(applicable_date) as ddate 
						 FROM ccp_" . $streamDetails['tableNameHolds'] . " 
						 WHERE applicable_date<'" . $startDate . "' 
						 AND " . $streamDetails['fieldName'] . "_id = " . $streamID;
		
			$dd = mxrAS_db_grabRows('AS',$earlyDateSQL,false);
		
			//Check if any otherwise leave $startDate as is...
			if(count($dd)>0){
				$startDate = "{$dd[0][0]}";
			}
		}
		
	}

	return mxrAS_getHAssetHoldings($startDate,$endDate,$streamChoice,$streamID);
}
function mxrAS_getHAssetHoldings($startDate,$endDate,$streamChoice,$streamID){
	
	$keyHolds = array();
	
	//So we check if it's not an instrument...
	if($streamChoice<4){
		
		$streamDetails = mxrAS_getStreamDetails($streamChoice);
		
		//This picks up both the holdings (with a timestamp that we have to figure out)
		$holdingsSQL = "SELECT applicable_date as ddate,timestamp,asset_id as aid, sum(value) as pos FROM
	    	            (SELECT applicable_date,timestamp,asset_id,value, RANK() OVER 
	        	        	(PARTITION BY applicable_date,asset_id ORDER BY timestamp DESC) mts 
	            	    FROM ccp_" . $streamDetails['tableNameHolds'] . "  
						WHERE applicable_date>='" . $startDate . "' AND applicable_date<='" . $endDate . "'
						 AND " . $streamDetails['fieldName'] . "_id = " . $streamID .") AS ww 
						WHERE ww.mts=1
						GROUP BY applicable_date, timestamp, asset_id";
			
		//Return holdings['ddate']['timestamp']['aid']['pos']
        //echo $holdingsSQL;
		$holds =   mxrAS_db_grabRows('AS',$holdingsSQL,false);
		
		//What if there aren't any rows...
		if (count($holds)<1) { 
			$keyHolds[$startDate]['207'] = 1; 
		} else {
		
		//Now populate the keyHolds vector.
			foreach($holds as $hold){
				$ddate = $hold['ddate'];
				$aid = $hold['aid'];
		
				$keyHolds[$ddate][$aid]=$hold['pos'];
			}
		}
	} else {
		//We have an instrument  - so the holdings are always 100% 
		$keyHolds['1980-01-01'][$streamID] = 1;
	}
	//print_r($keyHolds);
	return $keyHolds;
}	
function mxrAS_getTSeriesForSecID($radioDate,$streamID,$perfTypeID = 26,$nYears = 15, $hcType = 'line'){
	//Pull in the Returns from the rets_series_data table. 
	//We also let this function pull in risk data - so we set the $perfTypeID as <>0
	
	$startDateYr = 1*substr($radioDate, 0, 4) - $nYears;
	$startDate = "{$startDateYr}" . substr($radioDate,-(strlen($radioDate)-4)) ;
	
	//If we have <>0 perfTypeID then we want the risk numbers from the cov table...
	if($perfTypeID == 26) {
		$hcType  = ($hcType=='ScatterChart') ? 'scatter' : 'line';
		
		//The series_id is a slow join...
		//$mySQL = "SELECT d.ts,d.value,'Daily Perf.' as type_description,'p%4.2f' as type_format,'" . $hcType . "' as hcType,i.asset_name
		//	  	FROM rets_series_data d
		//		JOIN rets_series_desc des ON des.series_id = d.series_id
		//		JOIN ccp_instruments i ON i.iaa_aid = des.name
		//		WHERE i.asset_id = {$streamID} AND des.periodicity = 'D' AND des.groups=33
		//		AND d.ts<='{$radioDate}' AND d.ts>='{$startDate}'
		//		ORDER BY d.ts";

        $mySQL = mxrAS_SQLForTSeriesSecID($streamID);

	} else {
    	//We will grab the risk numbers.
    	$mySQL = "SELECT r.applicable_date,sqrt(r.var) as value,'Ex-Ante Risk' as type_descriptions,'p%4.2f' as type_format,'line' as hcType,i.asset_name
    			FROM ccp_exantecovar r
    			JOIN ccp_instruments i ON i.asset_id = r.secid1
    			WHERE r.secid1 = {$streamID} AND r.secid2 = {$streamID} AND r.applicable_date<='{$radioDate}' AND r.applicable_date >='{$startDate}' 
    			ORDER BY r.applicable_date";
    			
	}
	
	return mxrAS_db_grabRows('AS', $mySQL, false);
}

function mxrAS_SQLForTSeriesSecID($streamChoice){
    //We grab data from the rets_data table.

    //1 get the instrument and it's underlying series from rets
    $sqlInstrument = 'select iaa_aid from ccp_instruments i where asset_id =' . $streamChoice;
    $sqlID = 'select series_id from rets_series_desc where name = (' ;
    $sqlConstituents = 'select constituents from rets_series_constituents where series_id in (' . $sqlID ;
    $sql = "select ts,value from rets_series_data where series_id =( " . $sqlConstituents . $sqlInstrument . ") and enabled='YES' order by case when periodicity = 'W' then 'F' else periodicity end limit 1) and comp_order=0) order by ts";

    return $sql;
}

function mxrAS_SQL_TSeriesByTypeID(&$radioDate,$streamChoice,$streamID,$perfTypeID,&$typeDes,$scalar=1,$shift=0,$overrideDes='',$color='',$chartType='StockChart'){
	//We grab the stream details to generate the SQL to pull out the NAV into a time series. 
	
	$rows = mxrAS_getTSeriesByTypeID($radioDate,$streamChoice,$streamID,$perfTypeID,$chartType);
	
	//Grab key data...
	$typeFormat = $rows[0][3];
	$axisDes = $rows[0][2];
	if($overrideDes==''){
		$seriesDes = $rows[0][5];
	} else {
		$seriesDes = $overrideDes;
	}
	$startDate = $rows[0][0];
	
	
	if($rows[0][4]==""){
		$hcChartType='line';
	} else {
		$hcChartType = $rows[0][4];
	}
	
	//Fix up the dates for a highchart format
	date_default_timezone_set('UTC'); 
	
	//Fudges here - 
	$typeDes = "$seriesDes : Historical $axisDes";
	
	if($hcChartType=='scatter'){
		$ndp = 0;
		
		//Stick in here point z as the date format in the tooltip...
		//then refer to point.z in the tooltip.
		foreach ($rows as $key=>&$row){
			$radioDate = $row[0];
			$row = array('x'=>strtotime($row[0])*1000,'y'=>1*number_format($scalar*($row[1]+$shift),$ndp),'z'=>$row[0]);
		}
		
		//Set the chartOptions
		$chartOptions = mxrAS_HCGetChartOptions($hcChartType,$typeDes,'Return (bp)','<b>{series.name}</b><br>','<b>Return:</b> {point.y} bp on {point.z}');
		$chartData = mxrAS_HCSetChartData($hcChartType,$seriesDes,$rows,'',$color);
		
	} else {
		$ndp = 4;
		foreach ($rows as $key=>&$row){
			$radioDate = $row[0];
			$row=array(strtotime($row[0])*1000,1*number_format($scalar*($row[1]+$shift),$ndp));
		}
		//Set the chartOptions
		$chartOptions = mxrAS_HCGetChartOptions($hcChartType,$typeDes,$axisDes,'','');
		$chartData = mxrAS_HCSetChartData($hcChartType,$seriesDes,$rows,'dataseries',$color);
		
	}
	
	$jsCharts = array();
	$jsCharts[] = array('chartOptions'=>$chartOptions,'chartData'=>$chartData);
	return $jsCharts;
}

function mxrAS_getSSADefsInList(){
    $htmlOut = "";

    $mySQL = 'select sdefTitle, sdefDesc, sdefID from ccp_stressTests order by sdefID';
    $rows = mxrAS_db_grabRows('AS', $mySQL, false);


    foreach($rows as $r){
        $paras = explode('zzz', $r['sdefdesc']);

        $htmlOut .= "<h4 id='ssa_{$r['sdefid']}'>{$r['sdeftitle']}</h4>";
        foreach($paras as $p){
            $htmlOut .= "<p>{$p}</p>";
        }
    }
    return $htmlOut;
}

function mxrAS_MultiTSeriesByTypeID(&$radioDate,$streamChoice,$streamID,$perfTypeIDArray,&$typeDes,$multiSeries=true,$chartType = 'StockChart', $rscat = 0){
	//So we get passed an array of typeIDs and loop over - 
	//We either produce multiple charts or multiSeries. 
		
	$jsLoop = array();
	$askedForDate = $radioDate;
	
	foreach($perfTypeIDArray as $pID){
		//So we can pick out the returns for instruments here...
		$dummy = mxrAS_SQL_TSeriesByTypeID($radioDate,$streamChoice,$streamID,$pID['id'],$typeDes,$pID['scalar'],0,$pID['desc'],"{$pID['color']}",$chartType);
		
		$jsLoop[]=$dummy[0];
		$radioDate = $askedForDate;
	}
	
	//Set the Text for the Charts.
	$typeDes = $jsLoop[0]['chartOptions']['title']['text'];
	
	//Grab the last date for radioDate to send back...
	//On the first set of charts we want the last date.
	$lastData = end($jsLoop[0]['chartData']['data']);
	$radioDate = $lastData['z'];//probably should change it to 'date'...
	reset($jsLoop);
	
	//Reformat the jsLoop output...
	$seriesData = array();

	foreach($jsLoop as $jData){
		$seriesData[] = $jData['chartData'];
	}

	if ($rscat == 1) {
		$seriesData[0]['type'] = 'scatter';
	}

	foreach($seriesData as $k=>$s) {
		if ($k >= $rscat) {
			$seriesData[$k]['type'] = 'line';
		}
	}

	//Format the output with seriesData and the first set of chartoptions.
	$charts[] = array('chartOptions'=>$jsLoop[0]['chartOptions'],'chartData'=>$seriesData);
	return $charts;
}

function mxrAS_getMultiSeriesFromOneQuery(&$radioDate, $streamChoice, $streamID, $SQL, $multiSeries = true, $chartType = 'StockChart'){
    $jsLoop = array();
    $askedForDate = $radioDate;
}

function mxrAS_hasHolds($streamChoice,$streamID,$radioDate){
    //If it's an instrument the hasHolds is automatically true...

    $rFlag = true; //The default for an instrument - which is there.

    if($streamChoice<4){
        //This is for Portfolios, Views, and Strategies
		$sd = mxrAS_getStreamDetails($streamChoice);
        $SQL = "SELECT count(date_created) FROM ccp_" . $sd['tableNameHolds'] . " WHERE " . $sd['fieldName'] . "_id={$streamID} AND date_created<='" . $radioDate . "'";

        $nHolds = mxrAS_db_grabRows('AS',$SQL,false);
        if($nHolds[0][0]<=0){
            $rFlag = false;
        }
    } elseif ($streamChoice == 5) {
		//This is for the FUNDS section
		//$sd = mxrAS_getStreamDetails($streamChoice);
		//We have a mapping straight to classID and series_id which is a series of NAVs. 
		$SQL = "SELECT count(ts) from rets_series_data d join fhc_classes c on c.series_id = d.series_id where c.classID={$streamID} and ts<='" . $radioDate ."'";

		$nHolds = mxrAS_db_grabRows('AS',$SQL,false);
		if($nHolds[0][0]<=0){
			$rFlag = false;
		}
	}

    return $rFlag;
}
