<?php 

//Drop down lists 
//*Drop down lists */

function mxrAS_SQL_getUserStreamIDs($streamChoice,$streamDetails){
    //$post_id = get_queried_object_id();

    $mySQL = "select dept_id as " . $streamDetails['fieldName'] . "_id from ccp_viewLists where user_id = " .
        get_current_user_ID() . " and type_id = {$streamChoice}  order by dept_id";

   $rTemp = mxrAS_db_grabRows('AS', $mySQL);

    $rStr = "";
    foreach($rTemp as $v){
        //Rebuild array.
        if ($v[0]!=-1) {
            $rStr = $rStr . "{$v[0]},";
        }
    }

    $wSQL = "";
    if ($rStr!=""){
        //Strip off the trailing comma
        $rStr = substr($rStr, 0, -1);
        $wSQL = " AND p." . $streamDetails['fieldName'] . "_id in ({$rStr})";
    }

    return $wSQL;
}

function mxrAS_SQL_DDstreams($streamChoice, $ddName, $filterByUser = false, $atype='ALL_ALL'){
	//Grab the full list of stream choices...
	
	//Which set of tables?

    //Should change this to the class usage TODO May 2015
	$streamDetails = mxrAS_getStreamDetails($streamChoice);

	switch ($streamChoice){
		//Use fall through for 
		case 1: //Portfolios
		case 2: //Views
		case 3: //StreamFactoryPattern
		
			//Set up the SQL statement

            //first get the WHERE Clause

			$mySQL = "SELECT p." . $streamDetails['fieldName'] . "_id as k, p." . $streamDetails['fieldName'] . "_name as v 
					 FROM ccp_" . $streamDetails['tableNameRoot'] . " as p ";

            //If we filter by user then we need to reduce the list...

            if ($filterByUser){
                //So we do filter. It saves us a db call but we could just go run the func anyway..
                //Otherwise we show the dept/port id for only those in the query.
                $whereSQL = " WHERE p." . $streamDetails['activeStreamSQL'] . mxrAS_SQL_getUserStreamIDs($streamChoice, $streamDetails) . " ORDER BY v";

            } else {
                $whereSQL = " WHERE p." . $streamDetails['activeStreamSQL'] . "	ORDER BY v";
            }
            $mySQL = $mySQL . $whereSQL;
            $keys = ['opValue'=>'k', 'opLabel'=>'v'];

			break;
			
		case 4: //Instruments 
		
			//Account for the passed atype too...
			$atype = (!isset($atype) || empty($atype)) ? 'ALL_ALL' : $atype;
			$mySQL = mxrAS_getSQLInstrumentsByType('none', $atype);

            $keys = ['opValue'=>'asset_id', 'opLabel'=>'aname', 'opAtts'=>['duration'=>'Years', 'risk'=>'%']];
			break;
		
		case 5: //Options
			$mySQL = "SELECT i.series_id as k, trim(i.description) as v 
					  FROM rets_series_desc i
					  WHERE i.source='options' AND i.groups=38 AND enabled='YES'";
            $keys = ['opValue'=>'k', 'opLabel'=>'v'];
            break;
	}
	
	//echo $mySQL;
	$rows = mxrAS_db_grabRows('AS', $mySQL, false);
	
	//Build the dropdown box.
    //TODO SELROW change the 0 for selRow
	return mxrAS_buildDropDownWithNames($ddName, $rows, 0, $keys);
}

function mxrAS_SQL_DD_FXList($ddName,$checkUserCap,$filter = 'Currency',$prefList = true){
	$mySQL = "SELECT DISTINCT(substr(asset_name,10,3)) as k,substr(asset_name,10,3) as v FROM ccp_instruments 
			  WHERE asset_type='" . $filter . "' AND asset_name NOT IN ('Currency USD','Currency EUR', 'Currency GBP', 'Currency Emerging') ORDER BY k";
			  
    $extraRows = mxrAS_db_grabRows('AS',$mySQL,false);

    //Now handle the preferred currencies to be near the top...
    $rows = array();
    if ($prefList) {
        $ddList = array('USD', 'EUR', 'GBP');
        $i = 0;
        foreach ($ddList as $fx) {
            $rows[$i++] = array($fx, $fx, $fx => $fx);
        }
    }
    //Now put in extra rows at the start 
    return mxrAS_buildDropDown($ddName, $rows+$extraRows, 0);

}

function mxrAS_SQL_DD_groupList($ddName,$checkUserCap){
	$mySQL = "SELECT group_id as k, group_name as v FROM rets_groups ORDER BY group_name";
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);
	return mxrAS_buildDropDown($ddName,$rows,0);
}

function mxrAS_SQL_DD_sourceList($ddName,$checkUserCap){
	$mySQL = "SELECT source as k, source as v FROM rets_sources";
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);
	return mxrAS_buildDropDown($ddName,$rows,0);
}

function mxrAS_SQL_DD_assetTypeList($ddName,$checkUserCapabilities){
	
	//This gets the tradeGroups lists
	$mySQL = "SELECT grouplike || '_' || asset_type as k, groupDes as v from ccp_instruments_tradegroups where likeGroup = true order by asset_type, sortOrder";
	//$mySQL = "SELECT distinct(asset_type) as k, asset_type as v from ccp_instruments";
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);
	return mxrAS_buildDropDown($ddName,$rows,0);	
}

function mxrAS_SQL_DD_calcList($ddName,$checkUserCap){
	$mySQL = "SELECT method as k, method as v FROM rets_methods";
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);
	return mxrAS_buildDropDown($ddName,$rows,0);
}

function mxrAS_SQL_DD_periodList($ddName,$checkUserCap){
	$mySQL = "select periodicity as k, descript as v from rets_periodicities";
	$rows = mxrAS_db_grabRows('AS',$mySQL,false);
	return mxrAS_buildDropDown($ddName,$rows,0);
}
function mxrAS_SQL_DD_weightList($ddName,$checkUserCap){
		$mySQL = "SELECT name as k,array_agg(ROW(dept_name,data*100)) as v FROM (
					SELECT name,dept_name,data from ccp_strategies_weightings w
					JOIN ccp_strategies s ON w.asset_id=s.iaa_did GROUP BY name,dept_name,data
					) AS row
					GROUP BY name order by name";
		
		//This gives us a list of weight schema 
		$rows = mxrAS_db_grabRows('AS',$mySQL,false);
		
		//Now we need to parse the rows before we send to get built...
		foreach($rows as $key=>&$row){
			$row['v'] = preg_replace("/[^A-Za-z0-9(), ]/", '', $row['v']);
			$row['v'] = str_replace(")","%)",$row['v']);
			$row['v'] = str_replace("),("," :: ",$row['v']);
			$row['v'] = str_replace(",", " ",$row['v']);
			$row['v'] = preg_replace("/[()]/", '', $row['v']);
			
			$row[1]=$row['v'];
		}
		return mxrAS_buildDropDown($ddName,$rows,0);
}

function mxrAS_SQL_DD_stratList($ddName, $stypeID, $deptID, $chkUserCap){
    //Right now we can only hunt for strategies.
    if($stypeID == 2){
        $SQL = 'select substratid, "desc" from ccp_substrategies_desc
              where substratid in (
                select distinct(substrat_id) from ccp_strategies_holdings_details
                  where dept_id = {$deptID} and timestamp = (
                    select max(timestamp) from ccp_strategies_holdings where dept_id = {$deptID}
                  )
              )
              union select substratid, "desc" from ccp_substrategies_desc where substratid = 0';

        $rows = mxrAS_db_grabRows('AS', $SQL, true);
        $dd = mxrAS_buildDropDown($ddName, $rows,0);
    } else {
        $dd = "";
    }
    return $dd;
}
function mxrAS_SQL_DDSecIDList($ddName,$chkUserCap,$atypeID='ALL',$options = false){
	//Will ultimately have check universe...
	
	//First we restrict by the asset type unless 'ALL'
	$instruments = mxrAS_getInstrumentList("Update to Get Universe",$atypeID,$options);
	$selRow = 0;
	$html = "<select id='" . $ddName . "'>";
	foreach($instruments as $key=>$inst){
		$html .= '<option mxrAS_duration = ' . $inst['duration'] . ' mxrAS_risk = ' . $inst['risk'] . ' value="' . $key . '"';
		if($selRow==0){
			$html .=  ' selected="selected">';
			$selRow++;
		}else{
			$html .= '">' ;
		}
		$html.= $inst['atype'] .": " . $inst['aname'] . '</option>';
	}
	return $html;
}
