<?php
/***************************************************
* HTML Object Builders Library
* mxr AlphaSelect 2013
****************************************************/
function mxrAS_covTable($covMat,$cmd,$type = "Ex-Ante",$correl="CORREL"){
	//We return the markup for a cov table. 
	$covTable="<table id='mxrAS_{$cmd}' class='mxrAS_covMat'><thead><tr><th class='mxrAS_covLabel'>{$type} {$correl} MATRIX</th>";
	
	//Header
	$fields = array_keys($covMat);
	//Probably have the n:My_Name  - so want to strip off the the first part and give the row that id...
	foreach($fields as $f){
		$fName = explode(':',$f);
		$covTable .= "<th class='col_{$f} mxrAS_covLabel'>" . $fName[1] . "</th>";
	}
	$covTable .= "</tr></thead><tbody>";
	
	//Now the rows...
	foreach($covMat as $f=>$cRow){
	    $fName = explode(':',$f);
		$covTable .= "<tr class='row_{$f}'><td class='mxrAS_covLabel'>" . $fName[1] . "</td>";
		foreach($cRow as $cElem){
			$v = ($cElem=='NED') ? 'No Data' : number_format(100*$cElem,2);
			$covTable .="<td class='" . mxrAS_corrClasses($cElem) . "'>{$v}</td>";
		}
		$covTable .= "</tr>";
	}
	
	return $covTable . "</tbody></table>";
}

function mxrAS_corrClasses($corr){
	
	$classes="";
	
	//4 Classes :
	// 1 - Low (-0.25 to 0.25)
    if(abs($corr)<0.25){
    	$classes = "mxrAS_covLow";
    }
    
    // 2 - Negative
	if($corr<-0.25){
		$classes = "mxrAS_covNeg";
	}
	
	// 3 - Small Pos
	if($corr>=0.25){
		$classes = "mxrAS_covPosS";
	}
	
	// 4 - Meaningful +ve
	if($corr>0.5){
		$classes = "mxrAS_covPosL";
	}
	
	return $classes;	
}

function mxrAS_tableBodySimple($tableData){
	//Builds generic, classless body for a table. 
	//Assumes rectangular matrix in tableData...
	
	$tableStr="<tbody>";
	
	$nRows=count($tableData);
	$nCols=count($tableData[0]);//Assumes rectangular
	
	for($iRow=0;$iRow<$nRows;$iRow++){
    	$tableStr .= "<tr>";
    	for($jCol=0;$jCol<$nCols;$jCol++){
        	$tableStr .= "<td>" . $tableData[$iRow][$jCol] . "</td>";
    	}
		$tableStr .="</tr>";
	}
	
	return $tableStr .="</tbody>";
	
}
function mxrAS_tableBodyArray($tableData){
	//Pass $tableData where each row is prefixed and indexed by $rowH
	$tableStr="<tbody>";
	
	//We use the $tableData keys...as the row name
	foreach($tableData as $key=>$row){
		$tableStr .= "<tr><td class='mxrAS_rowName'>" . $key . "</td>";

        foreach($row as $subKey=>$elem){
		    //If it's a string then we just check if the first character is '-' and add the neg class...
		    $tableStr .= (substr($elem,0,1)=='-') ? "<td class='mxrAS_negRet'>{$elem}</td>" : "<td>{$elem}</td>";
		}

		$tableStr .= "</tr>";
	}
	return $tableStr .= "</tbody>";
}
function mxrAS_tableBodyArrayEdits($tableData, $editable, $hidden, $rowClasses, $colOrderByKey = ""){
	//Pass $tableData where each row is prefixed and indexed by $rowH

    //We have an issue if we wish to order the output in a specific way...we use $colOrderByKey
	$tableStr="<tbody>";
	
	$noEditClass = 'read_only';
	$hiddenClass = 'hidden';
	
	//We use the $tableData keys...as the row name
	$rID = 1;
	$tempKeys = array();

	foreach($tableData as $key=>$row){
		$cID = 0;
		
		//Add special class data supplied by rowClasses...
		$rClasses = array();
		$rClasses[] = "R$rID";

		if(array_key_exists($key, $rowClasses)){
			$rClasses[] = "{$rowClasses[$key]}";//Update in case the item is itself an array...
		}
		
		//Now build first row element...
        //$classString = ;

		$tableStr .= "<tr id='$key' class='" . implode(" ", $rClasses) . "'><td class='mxrAS_rowName R$rID C$cID $noEditClass'>$key</td>";

		//Then remaining row elements
        $tempRowStr = array(); //Simply clears the array for each row.

		foreach($row as $subKey=>$elem){
			//We must populate the table by the colOrderByKey array which
            //contains the key names in the correct order.

			//Add read only class
			$cID++;
			$classes = array();
			if(!in_array($subKey, $editable)){
				$classes[] = $noEditClass;
			}
			
			//Create all the hidden and R1 C1 classes
			if(in_array($subKey,$hidden)){
				$classes[] = $hiddenClass;
			} 
			$classes[]= "R" . $rID;
			$classes[]= "C" . $cID;

            $tempRowStr[$subKey] = "<td id='R{$rID}C{$cID}' class='" . implode(" ", $classes) . "'>$elem</td>";
		}

        //Now we need to figure out if the $colOrderByKey is populated then we do it in the right order.
        if ($colOrderByKey!=""){
            foreach ($colOrderByKey as $myKey){
                $tableStr .= $tempRowStr[$myKey];
            }
        } else {
            $tableStr .= implode("",$tempRowStr);
        }

		$tableStr .= "</tr>";
		$rID++;
	}
	//Return the table
	return $tableStr . "</tbody>";
}
function mxrAS_tableHeaderSimpleEdits($tableData,$hidden){
	//Builds a row of headers based on $tableData 
	$outputHtml="<thead><tr>";
	$hiddenClass = 'hidden';
	for($i=0;$i<count($tableData);$i++){
		if(in_array($i,$hidden)){
			$pre="<th class = 'hidden'>";
		} else {
			$pre="<th>";
		}
		$outputHtml .= $pre . $tableData[$i] . "</th>";
	}
	return $outputHtml . "</tr></thead>";
}

function mxrAS_tableBodyArrayKeys($tableData){
	//Pass $tableData where each row is prefixed and indexed by $rowH
	$tableStr="<tbody>";
	
	//We use the $tableData keys...as the row name
	$rID=0;
	foreach($tableData as $h=>$row){
		$cID=0;
		$tableStr .="<tr id='R" . ++$rID ."'><td class='mxrAS_rowName R$rID C$cID'>" . $h . "</td>";
		
		foreach($row as $elem){
			$tableStr .= "<td id='R" . $rID . "C" . ++$cID ."'>" . $elem . "</td>";
		}
		$tableStr .= "</tr>";
		$rID++;
	}
	return $tableStr .= "</tbody>";
}

function mxrAS_tableHeaderSimple($tableData){
	//Builds a row of headers based on $tableData 
	$outputHtml="<thead><tr>";
	for($i=0;$i<count($tableData);$i++){
		$outputHtml .= "<th>" . $tableData[$i] . "</th>";
	}
	return $outputHtml . "</tr></thead>";
}

function mxrAS_tableFooterSimple($tableData){
}


function mxrAS_simple_dropDown($dropDownData, $divID, $valCol=0, $labelCol=1, $selectedRow=1){
	//Builds drop down box from data array
	
	//Sanity check of data. 
	$nInputCols=count($dropDownData[0]);
	
	$valCol=min(abs($valCol),$nInputCols-1);
	$labelCol=min(abs($labelCol),$nInputCols-1);
	
	//Prepare html string.
	$listStr='';
	for($i=0;$i<count($dropDownData);$i++){
	
		if($i==$selectedRow){
			$appendStr='<option value="' . $dropDownData[$i][$valCol] . '" selected="selected">' . $dropDownData[$i][$labelCol] . '</option>';
			$selectedRow=-1;
		}else{
			$appendStr='<option value="' . $dropDownData[$i][$valCol]. '">' . $dropDownData[$i][$labelCol] . '</option>';
		}
		$listStr .= $appendStr;
	}
	
	return ('<select id="' . $divID . '">' . $listStr . '</select>') ;
	
}


add_action("genesis_before_post", "mxrAS_chartTableToolbar");
function mxrAS_chartTableToolbar(){

    $isHelpPost = has_category(33);
	//We can add some logic here - we can put a category to the posts that determine what the functionality is...
	if(is_single() && !$isHelpPost){
	
		//Bug fix as TAGS or CUSTOM TAXONOMY Not setup properly...
		$_BDTRADE = current_user_can('backdatetrades') && get_the_ID()==406;

		//Post ID = Correlations
		switch (get_the_ID()) {

            case 1052: //Stops Editor
                $_NODD = false;
                $_NODA = false;
                $_NOUP = false;
                $_EXPEXA = false;
                $_UNDERL = false;
                $_RADIO = true;
                $_INST = false;
                $_OPTION = false;
                $_KILLTRIGG = true;
                break;

            case 731 : //Alpha Stream Correlations.
				$_NODD = false;
				$_NODA = false;
				$_NOUP = true;
				$_EXPEXA = true;
				$_UNDERL = true;
				$_RADIO = true;
				$_INST = true;
				$_OPTION = false;
                $_KILLTRIGG = false;
				break;
				
			case 963: //Option Calculator
				$_NODD = false;
				$_NODA = false;
				$_NOUP = false;
				$_EXPEXA = false;
				$_UNDERL = false;
				$_RADIO = false;//Will show instruments if _INST = true.
				$_INST = true;
				$_OPTION = true;
                $_KILLTRIGG = false;
				break;
			
			case 928: //PSAT	
			case 725 : //PSS - Fall through to Next Case RSCAT 769
			 
				$_NODD = false;
				$_NODA = false;
				$_NOUP = false;
				$_EXPEXA = false;
				$_UNDERL = false;
				$_RADIO = true;
				$_INST = true;
				$_OPTION = false;
                $_KILLTRIGG = false;
				break;
				
			case 192 : // PTAB
				$_NODD = true;
				$_NODA = false;
				$_NOUP = false;
				$_EXPEXA = false;
				$_UNDERL = false;
				$_RADIO = true;
				$_INST = false;
				$_OPTION = false;
                $_KILLTRIGG = false;
                break;


           case 1208 :
                echo (get_current_user_id());

		   	case 1475:
			case 1471:
		   	case 871 :
			case 800 : //Add view
				$_NODD = true;
				$_NODA = true;
				$_NOUP = true;
				$_EXPEXA = false;
				$_UNDERL = false;
				$_RADIO = false;
				$_INST = false;
				$_OPTION = false;
                $_KILLTRIGG = false;
                break;


            case 999 : //Charts choices...
				break;
			default:
				$_NODD = false;
				$_NODA = false;
				$_NOUP = false;
				$_EXPEXA = false;
				$_UNDERL = false;
				$_RADIO = true;
				$_INST = true;
				$_OPTION = false;
                $_KILLTRIGG = false;
		}
	?>
	<div id='mxrAS_choiceArea' mxrAS_cmd='mxrAS_CMD'>
	<div class="one-third first">
	<?	
		if($_RADIO || $_INST){
			//We will need some Radio Boxes
	?>
		<div id='mxrAS_streamChoiceRadio' class='mxrAS_radioButtons' mxrAS_type='radio'>
	
	<?	
		}
			
		//Do we add the stream choices - almost always YES...
		if($_RADIO){
	?>
			<input type='radio' id='mxrAS_streamChoiceRadio-1' value=1 name='mxrAS_streamChoiceRadio' mxrAS_type='streamChoiceRadio'/><label for='mxrAS_streamChoiceRadio-1'>Portfolios</label>
			<input type='radio' id='mxrAS_streamChoiceRadio-2' value=2 name='mxrAS_streamChoiceRadio' mxrAS_type='streamChoiceRadio'/><label for='mxrAS_streamChoiceRadio-2'>Views</label>
			<input type='radio' id='mxrAS_streamChoiceRadio-3' value=3 name='mxrAS_streamChoiceRadio' mxrAS_type='streamChoiceRadio'/><label for='mxrAS_streamChoiceRadio-3'>Strategies</label>
	<?
	 	}
	 	
	 	//Do we need the instrument choices?
	 	if($_INST){
	?>      
			<? if($_OPTION){ ?>
				<input type='radio' id='mxrAS_streamChoiceRadio-5' value=5 name='mxrAS_streamChoiceRadio' mxrAS_type='streamChoiceRadio'/><label for='mxrAS_streamChoiceRadio-5'>Options</label>
				
			<? } else { ?>
				<input type='radio' id='mxrAS_streamChoiceRadio-4' value=4 name='mxrAS_streamChoiceRadio' mxrAS_type='streamChoiceRadio'/><label for='mxrAS_streamChoiceRadio-4'>Instruments</label>
				</div>
				<div id='mxrAS_atypediv' class='hidden'>
				<span id='mxrAS_atypeListWrapper' class='mxrAS_dropDown mxrAS_parentDropDown' mxrAS_childDD='mxrAS_streamListWrapper' mxrAS_type='dropDown' mxrAS_ajaxURL='mxrAS_DD' mxrAS_XP='dd-atypes ddName-mxrAS_atypeList' mxrAS_params='streamChoiceRadio snapshotDate'>Types ?</span>
				
	<?  
		
		}
	}
		
		//Close up if we needed to add a stream	
		if($_RADIO || $_INST){
	?>
		</div>
	<?
		}
	
		//The individual choice drop down - if has_tag('overview') then no otherwise yes...has_tag($noDropDown)
		if (!$_NODD){
	?>
		<span id='mxrAS_streamListWrapper' class='mxrAS_dropDown' mxrAS_type='dropDown' mxrAS_ajaxURL='mxrAS_DD' mxrAS_XP='dd-streams ddName-mxrAS_streamList' mxrAS_params='streamChoiceRadio snapshotDate atypeListWrapper'>
		<? 
			if($_OPTION) { 
		?>
			Security ?
		<? 
			} else { 
		?>
			Streams ?
		<? 
			} 
		?>
		</span>
	<? } ?>
	</div>
	<?
		//We display a date? has_tag($noDateBox)
		if (!$_NODA){
	?>
		<div class="one-third">
		<span id='mxrAS_snapshotDate' class='mxrAS_snapshotDate' mxrAS_type='date'>Date: <input name='mxrAS_snapshotDate' type="text" class='mxrAS_snapshotDate mxrAS_dateRange mxrAS_today' id='mxrAS_Summary_snapshotDate'/></span>
	<?
			if($_BDTRADE){
	?>
		<span id='mxrAS_backdatechk' class = 'mxrAS_checkbox mxrAS_source' mxrAS_dest='mxrAS_tradeDiv' mxrAS_type='chk'>Back Date? <input name='mxrAS_backdatechk' type="checkbox" class='mxrAS_chkbox' id='mxrAS_backdateTbox'/></span>
	<?
		}
	?>
		</div>
	<? }
		//Show the update button? has_tag($noUpdateButton)
		if(!$_NOUP){
    ?>
            <div class="one-third">

    <?
            if($_KILLTRIGG){

            ?>
                 <button id='mxrAS_CMD_updateButton' mxrAS_ajaxURL='mxrAS_CMD' class='mxrAS_updateButton mxrAS_CMD' mxrAS_params='streamChoiceRadio snapshotDate streamListWrapper KILLTRIGRadio' mxrAS_XP='b-sent x-sent'>Update</button>
          <?
            } else {

      ?>          <button id='mxrAS_CMD_updateButton' mxrAS_ajaxURL='mxrAS_CMD' class='mxrAS_updateButton mxrAS_CMD' mxrAS_params='streamChoiceRadio snapshotDate streamListWrapper' mxrAS_XP='b-sent x-sent'>Update</button>

                <?
            }
                ?>


            </div>
	<?	}
	
		//Or the Ex-Post Ex-Ante Radio has_tag($showExPostRadioTag)
		if($_EXPEXA){
	?>
		<div class = "one-third">
		<div id='mxrAS_EXPEXARadio' class='mxrAS_radioButtons' mxrAS_type='radio'>
			<input type='radio' id='mxrAS_EXPEXARadio-1' value=1 name='mxrAS_EXPEXARadio' mxrAS_type='EXPEXARadio'/><label for='mxrAS_EXPEXARadio-1'>Ex-Ante</label>
			<input type='radio' id='mxrAS_EXPEXARadio-2' value=2 name='mxrAS_EXPEXARadio' mxrAS_type='EXPEXARadio'/><label for='mxrAS_EXPEXARadio-2'>Ex-Post</label>
		</div>

	<? 
		if($_UNDERL){
	?>
		<div id = 'mxrAS_UNDERLRadio' class='mxrAS_radioButtons' mxrAS_type='radio'>
			<input type='radio' id = 'mxrAS_UNDERLRadio-1' value=1 name='mxrAS_UNDERLRadio' mxrAS_type='UNDERLRadio'/><label for= 'mxrAS_UNDERLRadio-1'>Drill Down Off</label>
			<input type='radio' id = 'mxrAS_UNDERLRadio-2' value=2 name='mxrAS_UNDERLRadio' mxrAS_type='UNDERLRadio'/><label for= 'mxrAS_UNDERLRadio-2'>Drill Down On</label>
		</div>	
		
	<? } ?>
		</div>
	<? } 
	    if($_KILLTRIGG){
    ?>
            <div class = "one-third">
                <div id='mxrAS_KILLTRIGRadio' class='mxrAS_radioButtons' mxrAS_type='radio'>
                    <input type='radio' id='mxrAS_KILLTRIGRadio-1' value='L' name='mxrAS_KILLTRIGRadio' mxrAS_type='KILLTRIGRadio'/><label for='mxrAS_KILLTRIGRadio-1'>Active</label>
                    <input type='radio' id='mxrAS_KILLTRIGRadio-2' value='UT' name='mxrAS_KILLTRIGRadio'
                           mxrAS_type='KILLTRIGRadio'/><label for='mxrAS_KILLTRIGRadio-2'>Triggered</label>
                </div>
            </div>
    <?   }?>

	</div>	
	<br/><br/><div class="clear-line"></div>
<?
}}
?>