<?php
/******************************************
**	All Highcharts Related Functions...  **
******************************************/

//Highcharts Functions

function mxrAS_HC_buildChartOptionsCol($cTitle,$xCats){
	return array(
		'title'=>array('text'=>$cTitle),
		'xAxis'=>array('categories'=>$xCats)
		);
}
function mxrAS_HC_buildChartOptionsTS($cTitle,$yTitle,$type){

	switch($type){
		case "HPOS":
		 $outputArray = array(
		 			'chart'=> array('alignTicks'=>false),
		 			'rangeSelector'=>array('selected'=>4),
		 			'title'=>array('text'=>$cTitle),
		 			'yAxis'=>array('title'=>array('text'=>$yTitle))
		 			);
		 break;
		
		default:
			$outputArray = array(
						'rangeSelector'=>array('selected'=>4),
						'title'=>array('text'=>$cTitle),
		    			'yAxis'=>array('title'=>array('text'=>$yTitle))
		    			);
	}

	return $outputArray;
}
function mxrAS_HCLegend(){
	//Returns a standard legend for the charts.
	return array(
			'enabled'=>true,
	    	'layout'=>'vertical',
	    	'align'=>'left',
	    	'verticalAlign'=>'top',
	    	'y'=>100
	    	);
}
function mxrAS_HC_buildChartResponse($chartOptions,$chartSeries,$radioDate,$n){
	return array('infoMsg'=> 'Request was successful.',
					  'astype'=>'success',
					  'controlType'=>'chart',
					  'chartType'=>'StockChart',
					  'nSeries'=>$n,
					  'chartOptions'=>$chartOptions,
					  'chartSeries'=>$chartSeries,
					  'rd'=>$radioDate
					);
}
function mxrAS_HCGetColors($id){
	//This function can return a singular value but in an array...
	
	$colors = array('#2f7ed8', '#0d233a', '#8bbc21', '#910000', '#1aadce', '#492970','#f28f43', '#77a1e5', '#c42525', '#a6c96a');
	
	if ($id<0){
		return $colors;
	} else { 
		$cid = $id % count($colors);
		$cid = ($cid == 0 ? 1 : $cid);
		return array($colors[$cid]);
	}
}
function mxrAS_HCGetCredits(){
	return array(
		'enabled'=>true,
		'href'=>'http://alphaselect.marketxray.com',
		'position'=>'null',
		'style'=>'null',
		'text'=>'Powered By AlphaSelect'
		);
}
function mxrAS_HCGetLabels($type,$data,$stepSize=0){
	
	switch ($type){
		case "xaxis":
			$labels = array(
    			'rotation'=> $data,
            	'align'=> 'right',
            	'style'=>array(
            		'fontSize'=> '13px',
                	'fontFamily'=> 'Verdana, sans-serif'
                	)
        		);
			if($stepSize!=0){
				$labels['step'] = $stepSize;
			}
			
        break;
        
        case "yaxis":
        	$labels = array(
                	'title'=>array(
                    	'text'=>$data
                    )
                );
        	break;
        
        case "dualYaxis":
        	$labels = array();
        	
        	foreach ($data as $d){
        		$labels[] = array(
        				'labels'=>array('format'=>$d['format'],'style'=>array('color'=>$d['color'])),
        				'title'=>array('text'=>$d['text'],'style'=>array('color'=>$d['color'])),
        				'opposite'=> $d['opposite']
        				);
        	}
            
        	break;
        	
        case "series":
        	$labels = array(
        		'enabled'=> true,
                'rotation'=> $data,
                'color'=>'#FFFFFF',
                'align'=> 'right',
                'x'=> 4,
                'y'=> 10,
                'style'=>array(
                    'fontSize'=> '13px',
                    'fontFamily'=> 'Verdana, sans-serif'
                    )
                );
        break;
    }
    
	return $labels;
}
function mxrAS_HCGetExporting(){
	return array(
			'scale'=>1,
			'sourceWidth'=> 800,
            'sourceHeight'=> 400);
}
function mxrAS_HCMakeMeta($controlType, $chartType, $passedParams, $charts, $mSeries, $preMsg, $newTitle="", $otherMsg = "xx"){
	
	//We pass the charts object to do 2 things - 
	$nCharts = count($charts);
	return array(
		'infoMsg'=>'Request was successful',
		'astype'=>'success',
		'controlType'=>$controlType,
		'chartType'=>$chartType,
		'passedParams'=>$passedParams,
		'nCharts'=>$nCharts,
		'multiSeries'=>$mSeries,
		'preMsg'=>$preMsg,
		'titleAppend'=>$newTitle,
        'otherMsg' => $otherMsg
		);
}

function mxrAS_HCMakeMultiBarCharts($results,$calcType,$riskData,$sView = true){
	$cashID = 207;
	
	$radioDate = $results['dDate'];
	
	$cTypeDetails = mxrAS_getCalcTypeDetails($calcType);

	//We'll employ the doRiskCalcs
	$risks = mxrAS_doRiskCalcs($results,$riskData,$calcType);
	$TE = $risks['TE'];
	
	//Now we build up the charts...
	//If there are multiple strats we'll do it by strat, otherwise we'll do it by asset class...
	$tok = $sView ? 'sid' : $results['dTok'];
	
	// So lets build up the charts first...
	$charts=array();
	
	//We loop inside the switch for repeated code but higher performance. 
	
	//We want to display position information for everything in the risk tooltip
	//And we want to include the ISOLATED risk too 
	$tooltip = '';
	
	switch ($calcType){
		case 'pos':
			foreach($results['dRows'] as $r){
				$chartKey = "{$r[$tok]}";
				
				if($tok=='sid') {
					$charts[$chartKey]['chartName'] = "{$r['sname']}";
				} else {
					$charts[$chartKey]['chartName'] = $chartKey;
				}
				
				$secID = (string)$r['aid'];	
				$isoRisk = sqrt(mxrAS_getCovar($riskData,$secID,$secID));
					
				
				$charts[$chartKey]['chartOptions']['xAxis']['categories'][]=$r['aname'];
				$charts[$chartKey]['chartData']['data'][]=array(
																'y'=>(double)(number_format($r['val']*100,2)),
																'z1'=>(number_format($isoRisk*100,2)),
																'z2'=>(double)(number_format($isoRisk*$r['val']*100,2)),
                                                                'z3'=>(double)(number_format($r['duration']*$r['val'],2)),
                                                                'z4'=>(double)(number_format($r['duration'],2))
                );
			}
			$tooltip = mxrAS_HCSetTableTooltip("Position %","Total Risk %","Isolated Risk %","Position Duration","Total Duration");
			break;

        case 'dur':

            foreach($results['dRows'] as $r){
                $chartKey = "{$r[$tok]}";

                if($tok=='sid') {
                    $charts[$chartKey]['chartName'] = "{$r['sname']}";
                } else {
                    $charts[$chartKey]['chartName'] = $chartKey;
                }

                $secID = (string)$r['aid'];
                $isoRisk = sqrt(mxrAS_getCovar($riskData,$secID,$secID));


                $charts[$chartKey]['chartOptions']['xAxis']['categories'][]=$r['aname'];
                $charts[$chartKey]['chartData']['data'][]=array(
                    'y'=>(double)(number_format($r['duration']*$r['val'],2)),
                    'z1'=>(number_format($isoRisk*100,2)),
                    'z2'=>(double)(number_format($isoRisk*$r['val']*100,2)),
                    'z3'=>(double)(number_format($r['val']*100,2)),
                    'z4'=>(double)(number_format($r['duration'],2))
                );
            }
            $tooltip = mxrAS_HCSetTableTooltip("Position Duration", "Total Risk %", "Isolated Risk %", "Position %", "Total Duration");
            break;

		case 'iso':		
			//We should filter the risk data and position data - 
			//like an intersect of sec id and $r[6];
			foreach($results['dRows'] as $r){
				$chartKey = $r[$tok];
				
				if( $r['aid']!=$cashID){
					if($tok=='sid') {
						$charts[$chartKey]['chartName'] = "{$r['sname']}";
					} else {
						$charts[$chartKey]['chartName'] = $chartKey;
					}
				
					$charts[$chartKey]['chartOptions']['xAxis']['categories'][]=$r['aname'];
					
				
					$secID = (string)$r['aid'];	
					$isoRisk = sqrt(mxrAS_getCovar($riskData,$secID,$secID));
					
					$charts[$chartKey]['chartData']['data'][]=array(
																'y'=>(double)(number_format($isoRisk*$r['val']*100,2)),
																'z1'=>(number_format($isoRisk*100,2)),
																'z2'=>(number_format($r['val']*100,2)),
                                                                'z3'=>(double)(number_format($r['duration']*$r['val'],2)),
                                                                'z4'=>(double)(number_format($r['duration'],2))
                    );
					
				}
			}
			$tooltip = mxrAS_HCSetTableTooltip("Isolated Risk %","Total Risk %","Position %","Position Duration","Total Duration");
			break;
		
		case 'mcr':		
			//Probably a great way to tidy this lot up but it's broken down for debug ease...
			// Set sigmaW - we should probably reuse the code elsewhere into one 'class'...
			foreach($results['dRiskIDs'] as $i){
				$idx=(string)$i;
				$sigmaW[$idx]=0;
				foreach($results['dRows'] as $j){
					$secID = (string)$j['aid'];
					$sigmaW[$idx] += mxrAS_getCovar($riskData,$idx,$secID) * $j['val'];
					
				}
				
			}
			
			
			// Now deduce Marginals
			foreach($results['dRows'] as $i){
				$secID=(string)$i['aid'];
				
				if($i['aid']!=$cashID){
					$sigmaW[$secID] = $sigmaW[$secID]*$i['val']/$TE;
					$chartKey = $i[$tok];
				
					if($tok=='sid') {
						$charts[$chartKey]['chartName'] = "{$i['sname']}";
					} else {
						$charts[$chartKey]['chartName'] = $chartKey;
					}
				
					$charts[$chartKey]['chartOptions']['xAxis']['categories'][]=$i['aname'];		
					
					$isoRisk = sqrt(mxrAS_getCovar($riskData,$secID,$secID));
					$charts[$chartKey]['chartData']['data'][]= array(
																'y'=>(double)(number_format($sigmaW[$secID]*100,2)),
																'z1'=>(number_format($isoRisk*100,2)),
																'z2'=>(number_format($i['val']*100,2)),
                                                                'z3'=>(double)(number_format($i['duration']*$i['val'],2)),
                                                                'z4'=>(double)(number_format($i['duration'],2))
                    );
				}
			}
			$tooltip = mxrAS_HCSetTableTooltip("Marginal Risk %","Isolated Risk %","Position %","Position Duration","Total Duration");
			
			break;
		
		case 'dv1':
			$delta = 0.01;//1% change (buy)
			foreach($results['dRows'] as $i){
				if($i['aid']!=$cashID){
					$thisIdx=(string)$i['aid'];
					//The change in variance is 			
					$d1 = mxrAS_getCovar($riskData,$thisIdx,$thisIdx)*$delta*$delta;
					$d2=0;
					foreach($results['dRows'] as $j){
						$k=(string)$j['aid'];
						$d2 += $j['val']*mxrAS_getCovar($riskData,$thisIdx,$k);
					}
			    
			    	$dS = sqrt($TE*$TE + $d1+$d2*$delta*2) - $TE;
			    
			    	$chartKey = $i[$tok];
			    
			    	if($tok=='sid') {
						$charts[$chartKey]['chartName'] = "{$i['sname']}";
					} else {
						$charts[$chartKey]['chartName'] = $chartKey;
					}
				
					$charts[$chartKey]['chartOptions']['xAxis']['categories'][]=$i['aname'];
					
					$isoRisk = sqrt(mxrAS_getCovar($riskData,$thisIdx,$thisIdx));
					$charts[$chartKey]['chartData']['data'][]= array(
																'y'=>(double)(number_format($dS*100,2)),
																'z1'=>(number_format($isoRisk*100,2)),
																'z2'=>(number_format($i['val']*100,2)),
                                                                'z3'=>(double)(number_format($i['duration']*$i['val'],2)),
                                                                'z4'=>(double)(number_format($i['duration'],2))
                    );
				}
			}
			$tooltip = mxrAS_HCSetTableTooltip("DV01 %","Isolated Risk %","Position %","Position Duration","Total Duration");
			
			break;
			
	}
	
	//Now we have some array reference issues in JS if we leave in this format...
	$jsCharts=array();
	$counter = 0;
	$chartDataName = $results['dRows'][0]['pid'];
	
	//This depends on how we have arranged $charts...$results['dTypes'] as $ut
	foreach($charts as $ut=>$thisChart){
		$myColors  = mxrAS_HCgetColors(++$counter);
	
		$jsCharts[]=array(
			'chartOptions'=>array(
				'chart'=>array(
					'type'=>'column'
					),
				'title'=>array(
					'text'=>$thisChart['chartName'] . " " . $cTypeDetails['titleText'] . " Carve Out For $chartDataName on $radioDate <br/>Overall Ex-Ante Risk : " . number_format($TE*100,2) . "%"
					),
				'xAxis'=>array(
					'categories'=>$thisChart['chartOptions']['xAxis']['categories'],
					'labels'=>mxrAS_HCGetLabels('xaxis',-45)
					),
				'yAxis'=> mxrAS_HCGetLabels('yaxis',$cTypeDetails['yAxisLabel']),
				'colors'=>$myColors,
				'credits'=>mxrAS_HCGetCredits(),
				'exporting'=>mxrAS_HCGetExporting(),
				'tooltip'=>$tooltip
                ),
			'chartData'=>array(
				'name'=>$chartDataName . " : " . $thisChart['chartName'],
				'data'=>$thisChart['chartData']['data'],
				)
			);
	}
	
	return $jsCharts;

}

function mxrAS_HCSetTableTooltipArray($Ydesc,$ZdescArray){
    $pointF = "";
    $template1 = "<tr><td style='padding:0'>";
    $template2 = ": </td><td style='padding:0'><b>{point.z";
    $template3 = "}</b></td></tr>";

    $i=1;
    foreach($ZdescArray as $Z){
        $pointF .= $template1 . $Z . $template2 . $i . $template3;
        $i++;
    }

    return array('crosshairs'=>"true",
            'headerFormat'=>'<span style="font-size:10px">{point.key}</span><table>',
            'pointFormat'=>$pointF,
            'footerFormat'=>"</table>",
            'shared'=>"true",
            'useHTML'=>"true");
}

function mxrAS_HCSetTableTooltip($Ydesc, $Z1desc, $Z2desc, $Z3desc, $Z4desc){
    //We make an array to iterate over..

    return  array('crosshairs'=>"true",
							 'headerFormat'=>'<span style="font-size:10px">{point.key}</span><table>',
							 'pointFormat' => "<tr><td style='color:{series.color};padding:0'>{$Ydesc}: </td>
							                      <td style='padding:0'><b>{point.y}</b></td></tr>
							                  <tr><td style='padding:0'>{$Z1desc}: </td>
							                  	  <td style='padding:0'><b>{point.z1}</b></td></tr>
							                  <tr><td style='padding:0'>{$Z2desc}: </td>
							                  	  <td style='padding:0'><b>{point.z2}</b2></td></tr>
							                  <tr><td style='padding:0'>{$Z3desc}: </td>
							                  	  <td style='padding:0'><b>{point.z3}</b2></td></tr>
							                  <tr><td style='padding:0'>{$Z4desc}: </td>
							                  	  <td style='padding:0'><b>{point.z4}</b2></td></tr>",
							'footerFormat' => '</table>',
                			'shared' =>"true",
                			'useHTML'=> "true");
}

function mxrAS_HCSetChartData($cType,$seriesDes,$rows,$id,$color){
	
	$chartData = array(
						'name'=> $seriesDes,
                		'data'=> $rows
                		);
    
	
	if ($cType!=''){
		$chartData['type'] = $cType;
	}
	
    if($id!=''){
    	$chartData['id'] = $id;
    }
    
    if($color!=''){
    	$chartData['color'] = $color;
    }
    
    
	return $chartData;
}
function mxrAS_HCGetChartOptions($cType,$titleText,$yAxisText,$headerFormat,$pointFormat){
	switch ($cType){
		case 'scatter':
			$chartOptions = array(
					'chart'=>array('zoomType'=>'xy'),
					'title'=>array('text'=>$titleText),
					'credits'=>mxrAS_HCGetCredits(),
		 			'exporting'=>mxrAS_HCGetExporting(),
		 			'subtitle'=> array('text'=>'(Pinch/Click and Drag To Zoom)','x'=>-20),
            		'xAxis'=>array('title'=> array('enabled'=>true,'text'=>'Date'),
						       'startOnTick'=>true,
						       'endOnTick'=>true,
						       'showLastLael'=>true,
						       'type'=>'datetime'),
					'yAxis'=>array('title'=>array('text'=>$yAxisText)),
					'plotOptions'=>array(
								'scatter'=>array('marker'=>array('radius'=>5,
								                                 'states'=>array(
								                                 		     'hover'=>array(
								                                 		               'enabled'=>true,
								                                 		               'lineColor'=>'rgb(100,100,100)'))),
								                 'states'=>array('hover'=>array('marker'=>array('enabled'=>true))),
								                 'tooltip'=>array('headerFormat'=>$headerFormat,
                        										  'pointFormat'=>$pointFormat)
												),
								'line'=>array('marker'=>array('enabled'=>false))
								)
						);
		break;
		
		default:
			$chartOptions = array(
					'rangeSelector'=>array('selected'=>4),
		 			'title'=>array('text'=>$titleText),
		 			'yAxis'=>array('title'=>array('text'=>$yAxisText)),
		 			'credits'=>mxrAS_HCGetCredits(),
		 			'exporting'=>mxrAS_HCGetExporting()
		 			);
		}
		return $chartOptions; 	
}
