<?php

//Instrument Based Functions
/*Instrument related queries */
function mxrAS_getInstrumentSingle($secID){
	$mySQL = $mySQL = "SELECT i.asset_id, i.asset_type atype, trim(leading i_asset_type from i.asset_name) aname, i.iaa_aid longId 
			  FROM ccp_instruments i 
			  WHERE i.active='Y' AND i.asset_id = " . $secID;
	
	return mxrAS_db_grabRows('AS',$mySQL,true);
}
function mxrAS_createNewParams($streamChoice,$id,$paramDate,$name,$pArray){

	//Build out the array of parameters to add...
	$myParams = array();
	foreach ($paramsArray as $k=>$p){
		$myVals[] = "({$id},'{$paramDate}','{$name}','{$k}','{$p[0]}',{$p[1]},{$p[2]})";
	}
	
	//Now the SQL
	$streamDetails = mxrAS_getStreamDetails($streamChoice);
	$mySQL = "INSERT INTO ccp_" . $streamDetails['tableNameRoot'] . "_params VALUES " . join(',' , $myVals);
	 
	//Connect and save
	$pgDb = mxrAS_db_connect('AS');
	$pgQuery = $pgDb->prepare($mySQL);
	$pgQuery->execute();

}
function mxrAS_addNewInstrument($ANIpacket,$underlying=true){
	//I need to fix this up so it actually works and handles cross rates etc.

	extract($ANIpacket);
	//Insert the new dsCode into PG
	$SQL = array();
	$SQL[] = "INSERT INTO temp_dscodes VALUES ('{$dsCode}','{$dsCode}',{$group},99)";
	
	$rows = mxrAS_db_grabRows('AS',"SELECT max(series_id) from rets_series_desc");
	$newID = $rows[0][0]+1;
	 
	$tempSQL = "INSERT INTO rets_series_desc VALUES (
		{$newID},'{$dsCode}','{$source}','{$desc}',{$group},'{$period}',null,'YES','{$dsCode}',null,null,null,null,null)";
	
	//If we need an underlying then we add that too...
	if ($underlying && $calcGroup==34){
		$tempID=$newID+1;
		
		$SQL[]  = $tempSQL . ",({$tempID},'{$shortName}','{$source}','{$desc}',33,'{$period}',null,'YES',null,null,null,null,null)";
	
		//This includes calculations..
		$SQL[] = "null";
		
		$SQL[] = "INSERT INTO rets_series_methods VALUES ({$tempID},{$TODOMethod}','{$base}',0)";
		//TODO Fix for method
		
		//Now included as an investable securtity
		$rows = mxrAS_db_grabRows('AS',"SELECT max(asset_id) from ccp_instruments");
		$assetID = $rows[0][0]+1;
		$insNameLong = $insType . " " . $desc;
		
		$userName = 'nick.laxton';//Perhaps pick up the user name.
		$SQL[] = "INSERT INTO ccp_instruments VALUES ({$assetID},'{$insNameLong}','{$insType}','Y','{$shortName}',null,'2003-01-01','{$userName}','Y',null,'Y','{$base}',1,4,null,null,null,null,null)";
		
		//Finally add to the instrument groups table..
		$SQL[] = "INSERT INTO ccp_instruments_groups VALUES ('ALL','{$shortName}')";
		
	} else {
		$SQL[] = $tempSQL;
	}
	
	//So now connect to the database...
	$pgDb = mxrAS_db_connect($dbName);
	
	//Now run through
	foreach($SQL as $statement){
		$pgQuery = $pgDb->prepare($statement);
		$pgQuery->execute();
	}
	//Should be good to go!
	return true;
}
function mxrAS_getSQLInstrumentsByType($universe,$atypeID='ALL_ALL'){
	//For now we ignore $myUniverseGroup in the query...in the db exists as models/signals/strategies params table...use getStreamDetails to figure out the asset group. 
	//Everything can have a custom asset group - explicit or dynamic etc...
	//For now you get everything but restricted by $atypeID.
	$atypes = explode('_',$atypeID);
	$atypeLike = $atypes[0];
	$atypeClass = $atypes[1];

    $mySQL = "";
    $durationSQL = mxrAS_getDurationSQL();
    $riskSQL = mxrAS_getRiskSQL();

	//Step 1 - If atypeID=ALL then we simply grab everything...
	switch ($atypeLike) {
	
		case 'ALL':
			//1 step grab everything...
			$mySQLWhere = "i.active = 'Y'";
			break;
		
		case 'XX' :
		//2 step - weird one as we grab everything in the asset group not like anything else..
			$whereSQL = "SELECT tg.groupLike FROM ccp_instruments_tradegroups tg 
						WHERE tg.asset_type='{$atypeClass}' and tg.grouplike<>'XX'";
			//Go get these...
			$whereRows = mxrAS_db_grabRows('AS',$whereSQL,true);
			$mySQLWhere = "i.asset_type = '{$atypeClass}'"; 
			foreach($whereRows as $r){
				$mySQLWhere .= " AND i.iaa_aid NOT LIKE '%" . $r['grouplike'] . "'";
			}
			$mySQLWhere .= " AND i.active='Y'";
			//For every row we need to join the array to make a where string. 
			break;

        case 'OPTION':
            //3 So we grab the options which are from a completely different place...
            $mySQL = "SELECT z.series_id, z.source atype, trim(z.description) aname, z.name longId, Y.duration
					  FROM rets_series_desc z
					  JOIN {$durationSQL}
					  AND z.source='options' AND z.groups=38 AND z.enabled='YES'";
            break;

		default :
		//1 step - we know the like from the atypeID of form LIKE_AssetType
		$mySQLWhere = "i.asset_type = '{$atypeClass}' AND i.iaa_aid LIKE '%{$atypeLike}' AND i.active='Y'";
	}

    if($mySQL == ""){
        $mySQL = "SELECT i.asset_id, i.asset_type atype, trim(leading i.asset_type from i.asset_name) aname, i.iaa_aid longId, Y.duration, Z.risk
				  FROM ccp_instruments i
				  JOIN {$durationSQL}
				  JOIN {$riskSQL}
				  AND {$mySQLWhere}
			  	ORDER BY i.asset_type, i.asset_name";
    }
	return  $mySQL;
}
function mxrAS_getInstrumentList($myUniverseGroup, $atypeID = 'ALL_ALL'){
	//For now we ignore $myUniverseGroup in the query...in the db exists as models/signals/strategies params table...use getStreamDetails to figure out the asset group. 
	//Everything can have a custom asset group - explicit or dynamic etc...
	//For now you get everything but restricted by $atypeID.

    $mySQL = mxrAS_getSQLInstrumentsByType($myUniverseGroup, $atypeID);

	//Grab the rows. 
	$rows = mxrAS_db_grabRows('AS',$mySQL,true);
	
	//print_r($rows);
	//Index on SecID
	$instruments = array();
	foreach($rows as $r){
		$secID = (string)$r['asset_id'];
		$instruments[$secID] = $r;
	}
	return $instruments;
}

//So this can be replaced with the IStream->getStreamName when in the class driven process.
function mxrAS_getPortfolioName($streamChoice,$streamID){
	if ($streamChoice!=5) {
		$streamDetails = mxrAS_getStreamDetails($streamChoice);
		$mySQL = "SELECT m." . $streamDetails['fieldName'] . "_name pid 
			  FROM ccp_" . $streamDetails['tableNameRoot'] . " as m
			  WHERE m." . $streamDetails['fieldName'] . "_id = {$streamID}";
	} else {
		$mySQL = "SELECT classDescShort as pid from fhc_classes where classID = {$streamID}";
	}
		//Make the database request for all the rows.
	$rows = mxrAS_db_grabRows('AS',$mySQL,true);
	return $rows[0]['pid'];
}

function mxrAS_mapInstrumentID2SeriesID($aidArr){
	//Works best for an array of IDs, returns array of form $a[insID]=seriesID;
	
	//String of ids for IN statement.
	$idStr = implode(",", $aidArr);
	
	//Build the SQL 
	$mySQL = "SELECT i.asset_id, d.series_id FROM ccp_instruments i 
		      INNER JOIN rets_series_desc d ON d.name = i.iaa_aid 
		      WHERE i.asset_type = 'Option' and groups=38 and i.asset_id IN ({$idStr})";
		      
	//get the rows. 
	$rows = mxrAS_db_grabRows('AS',$mySQL,true);
	
	//Rebuild the output...
	$IDmap = array();
	foreach($rows as $r){
		$aid = $r[0];
		$sid = $r[1];
		
		$IDmap[$aid] = $sid;
	}
	
	//send it back
	return $IDmap;
	
}
?>