<?php

/***************************************************
* Javascript and CSS Script Control Library
* mxr AlphaSelect 2013
****************************************************/
add_action('wp_enqueue_scripts','mxrAS_load_scripts');
function mxrAS_load_scripts()
{

    //Built a generalFunctions.php function to determine if a script sequence should be loaded...
    if (mxrAS_checkLoad_capcat()) {

        /**************************
         *    Style Sheets          *
         ***************************/
        $CSSqueueArray = [
            'mxrAS_jQueryUI_CSS' => array('path'=>'https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/cupertino/jquery-ui.css','v'=>false),
            'mxrAS_dataTable_CSS' => array('path'=>'js/DataTables-1.10.7/media/css/jquery.dataTables.min.css', 'v'=>true),
            'mxrAS_dtExport_CSS' => array('path'=>'js/DataTables-1.10.7/extensions/TableTools/css/dataTables.tableTools.min.css','v'=>true),
            'mxrAS_custom_CSS' => array('path'=>'css/custom.css','v'=>true)];

        $JSqueueArray = [
            'mxrAS_highcharts' => array('path' => 'https://code.highcharts.com/stock/highstock.js', 'dep' => array('jquery'), 'ver' => '', 'load'=>false),
            'mxrAS_hcExport' => array('path' => 'https://code.highcharts.com/stock/modules/exporting.js', 'dep' => array('mxrAS_highcharts', 'jquery'), 'ver' => '', 'load'=>false),

            'mxrAS_jEditable' => array('path' => 'js/jEditable.js', 'dep' => array('jquery'), 'ver' => '1.0a', 'load'=>true),
            'mxrAS_jqueryUI' => array('path' => 'https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js', 'dep' => array('jquery'), 'ver' => '', 'load'=>false),

            'mxrAS_dataTable' => array('path' => 'js/DataTables-1.10.7/media/js/jquery.dataTables.min.js', 'dep' => array('jquery'), 'ver' => '1.10.7', 'load'=>true),
            'mxrAS_dtExport' => array('path' => 'js/DataTables-1.10.7/extensions/TableTools/js/dataTables.tableTools.min.js', 'dep' => array('jquery', 'mxrAS_dataTable'), 'ver' => '2.2.4','load'=>true),

            'mxrAS_AjaxSetup' => array('path' => 'js/mxrAS_setupJS.js', 'dep' => array('mxrAS_jqueryUI', 'jquery'), 'ver' => '2.0a','load'=>true)
        ];

        //CSS Queue -
        foreach ($CSSqueueArray as $k => $v) {
            $path = ($v['v']) ? plugin_dir_url(__FILE__) : "";
            wp_register_style($k, $path . $v['path']);
            wp_enqueue_style($k);
        }

        //Scripts
        foreach ($JSqueueArray as $k => $v) {
            $path = ($v['load']) ? plugin_dir_url(__FILE__) : "";
            wp_register_script($k, $path . $v['path'], $v['dep'], $v['ver']);
            wp_enqueue_script($k);
        }

        //AJAX Setup - Register it.
        wp_localize_script('mxrAS_AjaxSetup', 'mxrAS_Ajax', array('ajaxurl' => admin_url('admin-ajax.php')));
    }
}
