<?php
/******************************************
**	All Watch List Related Functions...  **
******************************************/


function mxrAS_createNewStratIDFromTemp($pgDb,$insertArray){
	
	//We'll just save everything...
	$saveNewStrats = array();
	$sidValues = array();
	
	$userID = 1;
	
	//Go get the biggest stratID from the table to avoid duplicates...
	$pgQuery = $pgDb->prepare("SELECT max(substratid) FROM ccp_substrategies_desc");
	$pgQuery->execute();

	if($pgQuery->rowCount()==0){
		$new_sid = 2; //We'll reserve 0 and 1 for now...
	} else {
		$zRows = $pgQuery -> fetchAll();
		$new_sid = $zRows[0][0]+1;
	}

	//Now figure out all the -ve $sid - get the new master description rows and then figure out which sid need to be change.
	foreach($insertArray as $thisRow){
		//Do the update for the edit...
	
		//First we need to do something special for -ve strat ids. 
		$sid = $thisRow['stratid'];
		if($sid<0){
			//Then we take a note of it - assuming we haven't already set it...
			$idKey="$sid";
			
			if (!isset($saveNewStrats[$idKey])){
				//We want to take note of this id and name...and user...
				$saveNewStrats[$idKey] = "(" . $new_sid . ",'" . $thisRow['sname'] . "',$userID)";
				$sidValues[$idKey] = $new_sid++;
				//$updateVals[] = "UPDATE ccp_watch_lists SET stratid = " . $new_sid++ . " WHERE stratid = $sid and dept_id = " . $thisRow['dept_id'];
			}
		}
	}
	
	//So we have the info we need. 
	// 1  - Insert the new strategies into the master table
	$sqlIns = "INSERT INTO ccp_substrategies_desc VALUES " . implode(",",$saveNewStrats);
	$pgQuery = $pgDb->prepare($sqlIns);
	$pgQuery->execute();

	
	//Now change the sid to the new one in the array. 
	foreach($sidValues as $k=>$row){
		foreach ($insertArray as &$thisRow){
			if ($thisRow['stratid'] == $k){
				$thisRow['stratid'] = $row;
			}
		}
		//unset($thisRow['sname']);
		
	}
	
	return $insertArray;
}
function mxrAS_db_insertWatchFromArray($dbName,$insertArray,$tblName,$mode){

$pgDb = mxrAS_db_connect($dbName);

//This function handles any -ve sids which are not in the master table
//We need them in there as a foreign key prevents real posiotns being saved.
//This $insertArray has the sname stripped now...
$insertArray = mxrAS_createNewStratIDFromTemp($pgDb,$insertArray);

//Then we update first then insert...
$z = array();
$ups = 0;
			
foreach($insertArray as $thisRow){
	//Do the update for the edit...
	
	//Now update the main table with the undefined strat id - we will update later. 
	$sqlUpdate = "UPDATE $tblName 
				SET position = " . $thisRow['position'] . 
				" WHERE dept_id = " . $thisRow['dept_id'] . 
				" AND watch_date = " . $thisRow['watch_date'] . 
				" AND asset_id = " . $thisRow['asset_id'] . 
				" AND ptype = " . $thisRow['ptype'] . 
				" AND view_id = -999 AND wType = 'L'" . 
				" AND stratid = " . $thisRow['stratid'];
							
	$uExtra = " AND position <> " . $thisRow['position'];
		
	//Do we update?
	$pgQuery = $pgDb->prepare($sqlUpdate . $uExtra);
	$pgQuery->execute();
		        
	//We try and figure out if we updated or inserted. 
	if($pgQuery->rowCount()==0){
		//This could not update because the position was the same (so insert not needed). 
		//Try without the extra part...		    		
		$pgQuery = $pgDb->prepare($sqlUpdate);
		$pgQuery->execute();
		if ($pgQuery->rowCount()==0){
			//Definitely wasn't in there before...
			$tempRow = $thisRow;
			unset($tempRow['sname']);
			$z[] =  "(" . implode(",",$tempRow) . ")";
		} 
		    		
	} else {
		$ups++;
	}//Otherwise don't bother - you just updated it...
}

$tempKeys = $insertArray[0];
unset($tempKeys['sname']);
$sqlIns = "INSERT INTO $tblName (" . implode(",",array_keys($tempKeys)) . ") VALUES " . implode(",",$z);

$pgQuery = $pgDb->prepare($sqlIns);
$pgQuery->execute();

$mIns = ($pgQuery->rowCount() > 0) ? "Added " . $pgQuery->rowCount() . " new" : "No new watches";
$mUp = ($ups>0) ? "Updated $ups ." : "No updates";
$msg = $mIns . " | " . $mUp . "<br/>";

return $msg;
}
function mxrAS_tradeWatchList($wListArray,$streamChoice,$streamID,$radioDate,$rationale){
	
	if($streamChoice=="2"){
		//Saving new holdings is a 2 step process
		$pgDb = mxrAS_db_connect('AS');
	   
		//Step 1 - save a new record that has the new view id
		//Get the max view id.
		$pgQuery = $pgDb->prepare("SELECT max(view_id) from ccp_strategies_holdings");
		$pgQuery->execute();
		$res = $pgQuery->fetchAll();
		$viewID = $res[0]['max']+1;
	
		//get the User name?
		$userName = "'Nick Laxton'";
		
		//We're ready! - use the backdate for the timestamp and the date_created.
		$iSQL = "INSERT INTO ccp_strategies_holdings VALUES ($viewID,$streamID,'" . mxrAS_getRadioDate(1,$radioDate) . "','" . $rationale . "','" . mxrAS_getRadioDate(0) . "',$userName)";
		$pgQuery = $pgDb->prepare($iSQL);
		$pgQuery->execute();
		
		//Step 2 - Fill in the positions...
		$insertVals = array();
		
		extract($wListArray);
		//Sort out the number formats as we switch between views...
		mxrAS_viewFormatter($currTable,'currTable',0);
		
		//Set the n. decimal places..
		$precision = 6;
		
		foreach($currTable as $myKey =>$row){
			$z = explode("|",$myKey);
			$aid = $z[0];
			$sid = $z[1];
			
			// 0.0101556 -> 0.010156 i.e. 100th of bp
			$pval = round($row[3],$precision);
	
		//Should this be the backdate or today?	
			//if($pval!=0){
				$insertVals[] = "($viewID,$aid,0,$pval,'" . mxrAS_getRadioDate(0) . "',$userName,$sid)";
			//}
		}
		//Now execute the insert...
		$iSQL = "INSERT INTO ccp_strategies_holdings_details VALUES " . implode(",",$insertVals);
		//echo($iSQL);
		$pgQuery = $pgDb->prepare($iSQL);
		$pgQuery->execute();
		
		$pMsg = "Inserted New Holdings Into the Database";
		
	} else {
		$pMsg = "You can only trade strategies right now...";
	}
	return $pMsg;
}
function mxrAS_saveWatchList($wListArray,$streamID,$streamChoice,$softWatch,$radioDate){

	
	extract($wListArray);
	
	//Now we have an array of the data we can process and save it to the WatchDatabase...
	//All the database needs for the watch list -
	//streamID, pType, secID, wPos, watchDate, and tradedDate
	$saveWatchList = array();

	foreach($currTable as $myKey=>$row){
		//We want to save all positions if softWatch = false as this means the portfolio is self contained...
		//If sW = true we save just the positions that are different to the cpos. 
		
		$z = explode("|",$myKey);
		$secID = $z[0];
		$stratID = $z[1];
		
		if ( (!$softWatch && $row[3]=$row[2]) || ($row[3]!=$row[2]) ){ //Look at this logic for watches that are set to zero. 
			 $saveWatchList[]=array('dept_id'=>$streamID,
									'watch_date'=>"'" . $radioDate . "'",
									'asset_id'=>$secID,
									'position'=>$row[3],
									'trade_date'=>'null',
									'view_id'=>-999,
									'ptype'=>$streamChoice, 
									'wType' => "'L'",
									'stratid' => $stratID,
									'sname'=> $row[10]);
		}
	}
	
	//Now we have one key issue - we have the existing watch data that's being inserted too. 
	//So we need to insert a "DEL/LIVE/TRADE" into the db as part of the record. So any update will be now edit and we insert live. 
	//Or if we are in del mode we insert DEL instead of Live...
	$mode = 'update'; //This updates then inserts.
	
	// dept_id, watch_date,secID,wpos,$tradeDate="",viewID=-999,
	if (count($saveWatchList)>0){
	
		$preMsg = mxrAS_db_insertWatchFromArray('AS',$saveWatchList,"ccp_watch_lists",$mode);
		
		//Call the insert cmd
		if ($preMsg=='success'){
			$preMsg = "Saved " . count($saveWatchList) . " Watches To The Database as a New Watch List. ";
		}
		//else $insMsg = "PROBLEM SAVING WATCH LIST..."
	} else {
	//So we just need to prepare the insert statement...
		$preMsg = "Didn't find any data to save. ";
	}
	
	return $preMsg;
}

function mxrAS_getWatchList($streamID,$streamChoiceID,$snapShotDate){
	//We return an array just like that returned from getPortfolioWeights.

    //TODO stick the whole grabRows and this SQL into a Factory to make a Holdings Object - which is a collection of Positions.
    $streamDetails = mxrAS_getStreamDetails($streamChoiceID);
	
	//Will always return the latest list - 
	// For historical you'll need watch_date<trade_date in the table, disable view_id=-999
	// and then watch_date<=radioDate;
	$tok1 = 'atype';
	$tok2 = 'aid';
	$tok3 = 'sid';

    /*
	$substratSQL = ",h.substrat_id sid, substrats.desc as sname ";
	$joinStratSQL = " JOIN ccp_substrategies_desc substrats ON substrats.substratid = h.substrat_id ";
*/

    //This query requires a little work - for now we fudge the radio date...
    $durationSQL = mxrAS_getDurationSQL($snapShotDate);

	//Build the SQL statement
    //Here we need to pick the duration for the Watches...
	$mySQL = "SELECT DISTINCT ON (wl.asset_id, wl.stratID)
			  s.{$streamDetails['fieldName']}_name pid, wl.watch_date ddate, i.asset_type " . $tok1 . ", Y.duration,
				(trim(leading i.asset_type from i.asset_name)) aname, i.iaa_aid longId, wl.position val,
				 (CASE WHEN i.asset_type = 'Option' THEN 0 ELSE 1 END) as delta, wl.asset_id " . $tok2 . $streamDetails['subID2'] . " 
			  FROM ccp_watch_lists wl
			  JOIN ccp_instruments i on i.asset_id = wl.asset_id
			  JOIN {$durationSQL}
	          JOIN ccp_{$streamDetails['tableNameRoot']} s on s.{$streamDetails['fieldName']}_id = wl.dept_id " . $streamDetails['joinStratSQL2'] . " 
		      WHERE wl.view_id=-999 AND wl.dept_id = " . $streamID . " AND wl.ptype = " . $streamChoiceID . " AND wl.watch_date<='" . $snapShotDate . "' AND wl.wtype='L'  
			  ORDER BY wl.asset_id,wl.stratID,wl.watch_date DESC";
	
	$rows = mxrAS_db_grabRows('AS',$mySQL,true);
	if (count($rows)>0){
		//Replicate the portfolio weights array structure...
		$uniqueTypes = mxrAS_uniqueByKeyName($rows,$tok1);
		$uniqueSecIds = mxrAS_uniqueByKeyName($rows,$tok2);
		
		$uniqueStrats = mxrAS_uniqueByKeyName($rows,$tok3);
		
		$radioDate = $rows[count($rows)-1]['ddate'];
	}else{
		$uniqueTypes = array();
		$uniqueSecIds = array();
		$uniqueStrats = array();
		
		//Will this be ok for backdated procedures?? Jan 2014
		$radioDate = mxrAS_getRadioDate();
	
	}

    //TODO - create watchList objects - which in fact are like positions but extend them to have a date since watched...

	//I want the watchList to have the secID and stratID as the key...
	//We should seriously think of creating a viewRow class 
	$fudgeArray = array();
    foreach($rows as $r){
		//$secID = (string)$r[$tok2];
		//$stratID = (string)$r[$tok3];
        $newElement = array(
            'pid'=>$r['pid'],
            'ddate'=>$r['ddate'],
            $tok1=>$r[$tok1],
            'aname'=>$r['aname'],
            'longid'=>$r['longid'],
            'val'=>$r['val'],
            'duration'=>$r['duration'],
            'delta'=>$r['delta'],
            'sname'=>$r['sname'],
            $tok2=>$r[$tok2],
            $tok3=>$r[$tok3]
        );
        $fudgeArray[] = $newElement;
	}

    // Now we inject the optionDeltas etc....
    mxrAS_injectRealDeltas($fudgeArray, $radioDate, $uniqueSecIds);
    //echo('Made it here');
    //Make the $wl into the format secID, stratID
    $wl = array();
    foreach ($fudgeArray as $fElement){
        $stratID = (string)$fElement[$tok3];
        $secID = (string)$fElement[$tok2];
        $wl[$secID][$stratID] = $fElement;
    }

    $outputArray = array('dRows'=>$wl,'dDate'=>$radioDate,'dTypes'=>$uniqueTypes,'dTok'=>$tok1,'dRiskIDs'=>$uniqueSecIds,'dStratIDs'=>array());//Can we get the unique strats without breaking anything?$uniqueStrats);

    return $outputArray;
	  
}
function mxrAS_SQL_KWL($streamChoice,$streamID,$upDateType,$radioDate){

	//Connect to db
	$pgDb = mxrAS_db_connect('AS');


	if ($upDateType == 'T') {
		$tdate = $radioDate;
		$upDateType = "'T', trade_date = '" . $tdate . "'";
		
	} else {
		$upDateType = 'K';
	}
	
	//There's the chance we kill multiple times and violate a primary key. 
	//So let's quickly look up the view_id for killed items..,
	$checkKilled = "SELECT min(view_id) from ccp_watch_lists where view_id<>-999";
	$pgQuery = $pgDb->prepare($checkKilled);
	$pgQuery->execute();
	
	$res = $pgQuery->fetchAll();
	if ($res[0]['min']==""){
		$myView_ID = -1;
	} else {
		$myView_ID = $res[0]['min']-1;
	}
	
	//Now do the update...
	$mySQLUpdate = "UPDATE ccp_watch_lists SET wtype = '" . $upDateType . "',view_id=" . $myView_ID . " WHERE dept_id=" . $streamID . " AND ptype=" . $streamChoice . " AND wtype='L' AND watch_date<='" . $radioDate . "'";
	$pgQuery = $pgDb->prepare($mySQLUpdate);
	$pgQuery->execute();
	
	$z = $pgQuery->rowCount();
	if($z>0){
		$msg = "Stopped using the Watch List.";
	} elseif ($z==0){
		$msg = "No Watch Data Found...";
	} else {	
		$msg = "Seems like there's an error changing the Watch List";
	}
	return $msg;
	
}
function mxrAS_processWatchList($streamChoice,$streamID,$softWatch,$watchList,$rDate){
	//We actually want the latest possible date so set the $radioDate to be today...+2 to avoid server time zone issues.
	//$today = getDate();
	//$askDate = (string)$today['year'] . "-" . (string)$today['mon'] . "-" . (string)$today['mday'];
	
	//1st step - grab the Current Positions for the stream in question...
	$radioDate = $rDate;
	$currentWeights = mxrAS_getPortfolioWeights($radioDate,$streamChoice,$streamID);//Changed to pass an all zero flag.
	
	//Quickly re-key the weights - repeated code here but just get it going Sep13
	$pWeights = array();
	foreach($currentWeights['dRows'] as $c){
		$secID = $c['aid'];
		$stratID = $c['sid'];

        $pWeights[$secID][$stratID]=array('pid'=>$c['pid'],
						  				  'ddate'=>$c['ddate'],
						                  'atype'=>$c['atype'],
						   				  'aname'=>$c['aname'],
						                  'longid'=>$c['longid'],
						                  'val'=>$c['val'],
                                          'duration'=>$c['duration'],
						                  'delta'=>$c['delta'],
						                  'sname'=>$c['sname'],
                                          'dv01Setup'=>$c['dv01Setup']
						            );
	}
	$lastTradeDate = $currentWeights['dDate'];

	//2 Then the risk data
	$riskDate = $rDate;

    //We pass this the ids you just got! Otherwise the option logic will be lost.
    //Ideally a risk table object should be made - create the full matrix or a partial one based on the list IDs
    //actually needed.

    //So we now pass the ids from the current weights
    $myIDs = $currentWeights['dRiskIDs'];
	$riskData = mxrAS_getRiskTable($riskDate, $streamChoice, $streamID, $myIDs);//array());
	
	//TODO the risk calcs should reference the riskid in case it uses a proxy...
	//I can think of an issue though as the risk table may have to use a proxy itself to correctly reference any securities with multiple risks...
	//So the risk table etc should use the secID as the reference but look up the riskID as the source data and see how it is manipulated with the dv01Setup and delta.
	
	$currRisks = mxrAS_doRiskCalcs($currentWeights,$riskData,'mcr');

    //TODO 2014-10-15 You'll need to update the column name for the stratID to the ISOPOS risk...
    //Ultimately you'll need to move the columns around.
    $cols  = array('secID','Asset Name','Watched Since','Current Position %','Watch Position %','Effective Trade %','Duration (Yrs)','Security Risk %', 'Pre-Risk %','Post-Risk %','Isolated Risk %','Sub-Strategy');
	$currTable = array();
	
	//So now we recreate an UPSERTed array of $watchList['dRows'] and $pWeights...
	//The watchList is looped over first
	$watchButNotCurrent = 0;

	foreach($watchList['dRows'] as $secID=>$rows){
		foreach($rows as $stratID=>$wTemp){
			
			if(isset($pWeights[$secID][$stratID])){
				//OK so this is in the watch AND the current portfolio
				//So we merge the 2 data rows.
					$cpos = $pWeights[$secID][$stratID]['val'];
					$cRisk = $currRisks['posRisk'][$secID][$stratID];
                    $cIsoRisk = $currRisks['isoRisk'][$secID][$stratID]; //So we put the position weighted in the currTable below...
				} else {
					$cpos = 0;
					$cRisk = 0;
					$watchButNotCurrent++;
                    $cIsoRisk = 0;
				}
				
				$myKey = $secID . "|" . $stratID;
				$currTable[$myKey] = array(
									 $wTemp['atype'] . ":" . $wTemp['aname'],
									 (string)$wTemp['ddate'],
									 $cpos,
									 $wTemp['val'],
									 $wTemp['val'] - $cpos,
                                     $wTemp['duration'],
                                     $cIsoRisk, //CPOS weighted here.
									 $cRisk,
									 0,
									 $cIsoRisk*abs($cpos),
									 $wTemp['sname'],
                                     $wTemp['dv01Setup']);
		}
	}

    //We may have a situation where all positions are zero.
    //We would want to show them if they are all that way...
    $zeroVal = $currentWeights['allZero']==true ? -99999 : 0;

    //So far we have all the watches and those current positions that overlap.
	//Now we loop over all the current positions and add those that are not currently set...
	$softScalar = $softWatch ? 1:0; //Non watched items are a soft watch i.e. included as the current position
	
	foreach($pWeights as $secID=>$rows){
		foreach($rows as $stratID=>$zTemp){

            //So in order to appear here we must have non-zero current position.

			if(!isset($watchList['dRows'][$secID][$stratID]) && $zTemp['val']!=$zeroVal){
					$myKey = $secID . "|" . $stratID;
					$currTable[$myKey] = array(
										$zTemp['atype'] . ":" . $zTemp['aname'],
										'N/A',
										$zTemp['val'],
										$softScalar*$zTemp['val'],
										($softScalar-1)*$zTemp['val'],
                                        $zTemp['duration'],
                                        $currRisks['isoRisk'][$secID][$stratID], //So we put position weighted in the currTable.
										$currRisks['posRisk'][$secID][$stratID],
										0,
                                        $currRisks['isoRisk'][$secID][$stratID]*abs($zTemp['val']),
										$zTemp['sname'],
                                        $zTemp['dv01Setup']);
				}
			}
		}

	
	//C Inject new marginal risks into the calculations...Lots of clumsy code here that's crying out for some classes...
	//We also need to incorporate the strategy aspect for the risk. 
	$tempW=array();
	foreach($currTable as $myKey=>$c){
		$k = explode("|",$myKey);
		$secID = $k[0];
		$stratID = $k[1];
		
		$type = explode(':',$c[0]);
		$deltaType = ($type=='Option') ? 0:1;
		$tempW['dRows'][]=array('aid'=>$secID,'sid'=>$stratID,'val'=>$c[3],'delta'=>$deltaType,'duration'=>$c[5], 'dv01Setup'=>$c[11]);
		$tempW['dRiskIDs'][]=$secID;

        //We now don't need the dv01Setup in this row of the currTable
        unset($currTable[$myKey][11]);//It's all a bit of a mess really...
	}

	//We must check if we need to get the risk table again - $riskData only has tenors that match currentPositionSecIds. If new positions added we need new riskMatrices.
	if ($watchButNotCurrent>0){
		//We added securities so need a new risk data 
		$riskData = mxrAS_getRiskTable($riskDate,-1,-1,$tempW['dRiskIDs']);
	}
	
	$newRisks = mxrAS_doRiskCalcs($tempW,$riskData,'mcr');
	
	//D Update the risk data
	$to=0;
	foreach($currTable as $myKey=>$c){
		$k = explode("|",$myKey);
		$secID = $k[0];
		$stratID = $k[1];
		
		$currTable[$myKey][8] = $newRisks['posRisk'][$secID][$stratID];
		$to += $currTable[$myKey][4];
	}
	
	$cp = count($currentWeights['dRows']);
	$wp = count($watchList['dRows']);


	return array('cp'=>$cp,'wp'=>$wp,'cols'=>$cols,'currTable'=>$currTable,'currRisks'=>$currRisks,'newRisks'=>$newRisks,'to'=>$to,'radioDate'=>$lastTradeDate,'watchButNotCurrent'=>$watchButNotCurrent);
	
}
function mxrAS_viewFormatter(&$objectIn,$objType,$inOutFlag){

	//So far just uses a currTable
	switch ($objType){
		case 'currTable':
			if($inOutFlag==1){
				//Incoming Data to Unwind;
				$fArray = array(array('col'=>2, 'sf'=>0.01, 'ndp'=>-1),
								array('col'=>3, 'sf'=>0.01, 'ndp'=>-1),
								array('col'=>4, 'sf'=>0.01, 'ndp'=>-1),
								array('col'=>5, 'sf'=>1, 'ndp'=>-1),
								array('col'=>6, 'sf'=>0.01, 'ndp'=>-1),
                                array('col'=>7, 'sf'=>0.01, 'ndp'=>-1),
                                array('col'=>8, 'sf'=>0.01, 'ndp'=>-1),
                                array('col'=>9, 'sf'=>0.01, 'ndp'=>-1)
							);
			} else {
				// Output data to format...//
				$fArray = array(array('col'=>2, 'sf'=>100, 'ndp'=>3),
								array('col'=>3, 'sf'=>100, 'ndp'=>3),
								array('col'=>4, 'sf'=>100, 'ndp'=>2),
                                array('col'=>5, 'sf'=>1, 'ndp'=>2),
                                array('col'=>6, 'sf'=>100, 'ndp'=>2),
                                array('col'=>7, 'sf'=>100, 'ndp'=>2),
                                array('col'=>8, 'sf'=>100, 'ndp'=>2),
                                array('col'=>9, 'sf'=>100, 'ndp'=>2)
								);
			}
			
			//Now change the formats..
			foreach($objectIn as $myKey=>&$myRow){
				foreach($fArray as $fmt){
					$temp = $myRow[$fmt['col']]*$fmt['sf'];
					if($fmt['ndp']!=-1){
						$temp = number_format($temp,$fmt['ndp']);
					}
					$myRow[$fmt['col']] = $temp;
				}
			}
			
			break;
		
		case 'wlEdits':
			$sf = $inOutFlag==1 ? 0.01 : 100;

            foreach($objectIn as &$myRow){
				$myRow['wPos'] = $sf*$myRow['wPos'];
			}
			
			break;

        case 'stops':
            $sf = $inOutFlag==1 ? 0.01 : 100;

            $ndp = 3;
            $names = ['stoploss', 'tradeamt', 'perfdiff'];
            foreach($objectIn as &$myRow){
                foreach($names as $name){
                    $myRow[$name] = $sf*$myRow[$name];
                    if($inOutFlag!=1){
                        $myRow[$name] = number_format($myRow[$name], $ndp);
                    }
                }
            }

            break;

    }
	
}

function mxrAS_getWatchListCore($streamChoice, $streamID, $radioDate, $softWatch, $preMsg){
	$watchList = mxrAS_getWatchList($streamID, $streamChoice, $radioDate);


	//Get the saved watchList and rowClasses.
	$addRowClasses = array();
	foreach($watchList['dRows'] as $secID=>$w){
		foreach($w as $stratID=>$inner){
			$k = $secID . "|" . $stratID;
			$addRowClasses[$k] = "mxrAS_saved";
		}
	}
    //Think this is where we have to strip out any rowClasses we don't want? - most of the time it doesn't have a watch list...

    //In here though...
    $wListArray = mxrAS_processWatchList($streamChoice, $streamID, $softWatch, $watchList, $radioDate);
	$wListArray['addRowClasses'] = $addRowClasses;

    //Could probably recode the function to not take the preMsg...
    $wListArray['preMsg'] = $preMsg;
    
    return $wListArray;
}

function mxrAS_setWatchListCore($streamID, $streamChoice, $wlEdits, $softWatch, $rationale, $radioDate){
	//First we unformat the $wlEdits into a different form...
	if($wlEdits!='NO DATA'){
		mxrAS_viewFormatter($wlEdits,'wlEdits',1);
	}
	
	$wListArray = mxrAS_prepareWatchListData("mxrAS_saved", $streamID, $streamChoice, $softWatch, $wlEdits, $radioDate);
	if($wlEdits!='NO DATA'){
		$preMsg = mxrAS_saveWatchList($wListArray, $streamID, $streamChoice, $softWatch, $radioDate);
        //We now need to regrab the saved list
		$wListArray = mxrAS_getWatchListCore($streamChoice, $streamID, mxrAS_getRadioDate(), true, "");
		
	} else {
		$preMsg = 'No watches to save.';
	}
	
	
	return mxrAS_buildWatchListTable($wListArray, $preMsg, $streamID);
}
function mxrAS_buildWatchListTable($wListArray, $iMsg, $streamID, $hasStops = 0){
	extract($wListArray);
	//Now build out the output...And keep the edited class for the rows we just injected...Which is done in bodyArrayEdits as the last param...
	
	//Tidy up the data columns: We can dress this into more of a formatter function, with format properties etc...
	mxrAS_viewFormatter($currTable, 'currTable', 0);

    //Make the table.
	$tableHtml = "<table id='mxrAS_WLT_table' class='mxrAS_dataTableEdit display compact'>"
				. mxrAS_tableHeaderSimpleEdits($cols, array(0))
				. mxrAS_tableBodyArrayEdits($currTable, array(3,4), array(0), $addRowClasses)
			 	. "</table>";
	
	if($iMsg!=""){
		$preMsg = $iMsg;
	}

	$infoMsg = "<div id = 'mxrAS_postMsg' class='note-box'>Last Positions found on {$radioDate} <br/> $preMsg $cp Current Positions | $wp Watch Positions | $watchButNotCurrent New Entries | Current Risk: " . number_format($currRisks['TE']*100,2) . 
					"% | POST Risk: " . number_format($newRisks['TE']*100,2) . "% | Turnover: " . number_format($to*100,2) . "%</div>"; 
	
	// So this is a kluge job to sort it out. 
	$dTableParams = array('bJQueryUI'=> false,
        				  'bPaginate'=> false,
        				  'bFilter'=> false,
                          'bInfo'=>false,
        				  'bSort'=> true,
        				  'sScrollY'=>"1000px",
        				  'aaSorting'=> array(array(9,'desc'),array(1,'desc'),array(2,'desc')),
        				  'bRetrieve'=> true,
                          'sDom'=>"Tlfrtip",
                          'oTableTools'=>array('sSwfPath'=>plugin_dir_url(__FILE__) . 'js/DataTables-1.10.7/extensions/TableTools/swf/copy_csv_xls_pdf.swf')
        				);
        				
    //Build the table object...  				
	$table = array('divID'=>'mxrAS_WLT_dataTable', 
					'tDOM' => 'mxrAS_WLT_table',
					'data' =>$tableHtml,
					'msg'=>$infoMsg,
					'dTableParams'=> $dTableParams
					);

    //Does the stream have any stops?

	$pParams = array('snapshotDate'=>$radioDate,'streamListWrapper'=>$streamID, 'hasStops'=>$hasStops);
	$metaData = mxrAS_HCMakeMeta('tableArray','',$pParams,'',0,$infoMsg);
	
	//$table = array('cols'=>$cols,'dataTable'=>$tableHtml,'ID'=>'mxrAS_WLT_dataTable');
	//$pParams = array('snapshotDate'=>$radioDate,'streamListWrapper'=>$streamID);
	//$metaData = mxrAS_HCMakeMeta('table','',$pParams,'',0,$infoMsg);
	
	//Output the data.
	return array('meta'=> $metaData, 'table'=> array($table));
}
function mxrAS_prepareWatchListData($editedClass, $streamID, $streamChoice, $softWatch, $wlEdits, $radioDate){
	
	$watchList = mxrAS_getWatchList($streamID, $streamChoice, $radioDate);

    $addRowClasses=array();
	
	if($wlEdits != "NO DATA"){
		//Step 3 - Now inject the edits we have - should be an array [index][secID]=val, [index][wPos]=valection WL not null. 
		$preMsg  = "THIS DATA CONTAINS UNSAVED EDITS<br/>";

        $instruments = mxrAS_getInstrumentList('Todo - send asset universe for this stream'); //If needed we'll load an instrument list, but only once...

        //TODO - something wrong with this injection process that is breaking in the injectRealDeltas...
        $fudgeArray = array();

		foreach($wlEdits as $wlInject){
			$secID = (string)$wlInject['secID'];
			$wPos = (float)$wlInject['wPos'];
            $stratID = (string)$wlInject['stratID'];//TODO 2014-10-15 The source of this is no longer a column but is still sent to you here...so check that workds.
			$sname = (string)$wlInject['sname'];

           	//Keep track of the edited rows in $addRowClasses['secID']='editedClass';
			$addRowClasses[$secID . "|". $stratID] = $editedClass;
		
			//Now inject the data or add a new row.
			if(is_numeric($wPos)){
				if(isset($watchList['dRows'][$secID][$stratID])){
					//Edit row
					$watchList['dRows'][$secID][$stratID]['val'] = $wPos;
				} else {
					//Add new row...And it's today - no back fill allowed.
					//We need to pick up the new data from db from sec ID etc or pass it in the query to here...we would have it from client side select...but pick up server side...
                    //TODO the delta needs to be determined from the instrument list as to 0/1
					$newElement =array('pid'=>$streamID,
                                       'ddate'=>$radioDate,
									   'aid'=>$secID,
									   'aname'=>$instruments[$secID]['aname'],
									   'longid'=>$instruments[$secID]['longid'],
									   'atype'=>$instruments[$secID]['atype'],
									   'val'=>$wPos,
                                       'duration'=>$instruments[$secID]['duration'],
                                       'delta'=>1,
									   'sname'=>$sname,
                                       'stratID'=>$stratID);

                    $watchList['dRows'][$secID][$stratID] = $newElement;
                    //And now we injected the deltas - the actual watchList (i.e. bit without the injects already has them in.
                    //So this is getting to be a bit of a fudge but we need to add to our fudgeArray...
                    $fudgeArray[] = $newElement;
                }
			}		
		} //End the loop...

        //Just putting this on hold for now.

        $riskIDs = array();//mxrAS_uniqueByKeyName($watchList,'dRiskIDs');
        mxrAS_injectRealDeltas($fudgeArray, $radioDate, $riskIDs);

        //Now we need to adjust the fudgeArray back into the watchList.
        //What a mess! We need to simplify with some better objects...
        foreach($fudgeArray as $fudgeElement){
            $secID = $fudgeElement['aid'];
            $stratID = $fudgeElement['stratID'];

            unset($fudgeElement['stratID']);
            $watchList['dRows'][$secID][$stratID] = $fudgeElement;
        }

    } else {
    	$preMsg = "No temporary watches sent...<br/>";
    }


    //And now we process the watchlist to generate any risks etc..
    $z =  mxrAS_processWatchList($streamChoice,$streamID,$softWatch,$watchList,$radioDate);
    $z['addRowClasses'] = $addRowClasses;
    $z['preMsg'] = $preMsg;
    return $z;
}