<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

/**
 * The breadcrumbs configuration array.
 *
 * If child theme contains a `breadcrumbs.php` config, it will be used instead of this config.
 *
 * @since 2.7.0
 */
return array(
	'home'                    => __( 'Home', 'genesis' ),
	'sep'                     => ' <span aria-label="breadcrumb separator">/</span> ',
	'list_sep'                => ', ',
	'prefix'                  => genesis_markup(
		array(
			'open'    => '<div %s>',
			'context' => 'breadcrumb',
			'echo'    => false,
		)
	),
	'suffix'                  => genesis_markup(
		array(
			'close'   => '</div>',
			'context' => 'breadcrumb',
			'echo'    => false,
		)
	),
	'heirarchial_attachments' => true,
	'heirarchial_categories'  => true,
	'labels'                  => array(
		'prefix'    => __( 'You are here: ', 'genesis' ),
		'author'    => __( 'Archives for ', 'genesis' ),
		'category'  => __( 'Archives for ', 'genesis' ),
		'tag'       => __( 'Archives for ', 'genesis' ),
		'date'      => __( 'Archives for ', 'genesis' ),
		'search'    => __( 'Search for ', 'genesis' ),
		'tax'       => __( 'Archives for ', 'genesis' ),
		'post_type' => __( 'Archives for ', 'genesis' ),
		'404'       => __( 'Not found: ', 'genesis' ),
	),
);
