<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

$genesis_wp_version  = '4.7';
$genesis_php_version = '5.3';

/**
 * The requirements configuration. An environment that does not meet these minimums will not be able to use Genesis.
 *
 * @since 2.7.0
 */
return array(
	'wordpress' => array(
		'version' => $genesis_wp_version,
		'i18n'    => array(
			/* translators: 1: Version of WordPress that Genesis requires. 2: The WordPress version on this site */
			'requirements' => sprintf( __( 'Genesis requires WordPress version %1$s or higher. You are using version %2$s. Please upgrade WordPress to use Genesis.', 'genesis' ), $genesis_wp_version, $GLOBALS['wp_version'] ),
		),
	),
	'php'       => array(
		'version' => $genesis_php_version,
		'i18n'    => array(
			/* translators: 1: Version of PHP that Genesis requires. 2: The PHP version on this site */
			'requirements' => sprintf( __( 'Genesis requires PHP version %1$s or higher. You are using version %2$s. Please <a href="%3$s">upgrade PHP</a> to use Genesis.', 'genesis' ), $genesis_php_version, PHP_VERSION, 'https://wordpress.org/support/upgrade-php/' ),
		),
	),
);
