---
title: Contribute to Genesis
menuTitle: Contribute
layout: layouts/base.njk
permalink: contribute/index.html
tags: docs
---

Thank you for your interest in contributing to Genesis! There are many ways you can get involved:

1. [Give general feedback](#general-feedback)
2. [Contribute to Genesis](#genesis-core)
3. [Contribute to Genesis Sample](#genesis-sample)
4. [Contribute to Genesis developer documentation](#genesis-developer-documentation)
5. [Join the community](#the-genesis-community)

## General feedback

To report bugs or make a feature request, contact our friendly support teams or share your thoughts in Slack:

- <a href="{{ '/contribute/community/#genesiswp-slack-workspace' | url }}">GenesisWP Slack workspace</a>
- [StudioPress customer support](https://my.studiopress.com/help/)
- [WP Engine customer support](https://my.wpengine.com/support)

## Genesis core

We'd love your help shaping the future of Genesis, whether you have an active interest in contributing features or fixes, or you depend on Genesis for your work and want to keep track of upcoming changes.

Genesis uses a [private GitHub repository](https://github.com/studiopress/genesis). Learn how to access it here:

<a href="{{ '/contribute/genesis-core/' | url }}" class="button">Contribute to Genesis Core</a>

## Genesis Sample

Genesis Sample is a starter child theme for people making sites with Genesis. It's a theme you can build upon and adapt that often showcases new or upcoming features from Genesis.

Genesis Sample has a [public GitHub repository](https://github.com/studiopress/genesis-sample), a [public release history](https://github.com/studiopress/genesis-sample/releases), and contributions are welcome.

<p class="notice-small">
If you're new to contributing to open source projects, check the <a href="https://github.com/studiopress/genesis-sample/issues?q=is%3Aissue+is%3Aopen+label%3A%22good+first+issue%22"><em>good first issue</em> label</a>, and feel free to ask for help in the <a href="{{ '/contribute/community/#genesiswp-slack-workspace' | url }}">GenesisWP Slack</a> contributors channel.
</p>

<a href="https://github.com/studiopress/genesis-sample/" class="button">Contribute to Genesis Sample</a>

## Genesis developer documentation

The developer documentation you're reading is maintained in the Genesis repository, and contributions are welcome.

<a href="{{ '/contribute/genesis-docs/' | url }}" class="button">Contribute to Genesis Docs</a>

## The Genesis community

You don't have to write code or documentation to contribute to Genesis. You'll find our most active contributors in the Genesis community groups answering questions and sharing their knowledge:

<a href="{{ '/contribute/community/' | url }}" class="button">Join the Genesis community</a>
