<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

?>
<table class="form-table">
<tbody>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'doctitle' ); ?>"><b><?php esc_html_e( 'Custom Document Title', 'genesis' ); ?></th>
		<td>
			<p><input class="large-text" type="text" name="<?php $this->field_name( 'doctitle' ); ?>" id="<?php $this->field_id( 'doctitle' ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'doctitle' ) ); ?>" /></p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'doctitle' ); ?>"><b><?php esc_html_e( 'Meta Description', 'genesis' ); ?></th>
		<td>
			<p><input class="large-text" type="text" name="<?php $this->field_name( 'description' ); ?>" id="<?php $this->field_id( 'description' ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'description' ) ); ?>" /></p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="<?php $this->field_id( 'doctitle' ); ?>"><b><?php esc_html_e( 'Meta Keywords', 'genesis' ); ?></b></th>
		<td>
			<p><input class="large-text" type="text" name="<?php $this->field_name( 'keywords' ); ?>" id="<?php $this->field_id( 'keywords' ); ?>" value="<?php echo esc_attr( $this->get_field_value( 'keywords' ) ); ?>" /></p>
			<p class="description"><?php esc_html_e( 'Comma separated list', 'genesis' ); ?></p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><?php esc_html_e( 'Robots Meta Tags', 'genesis' ); ?>
			<a href="https://yoast.com/robots-meta-tags/" target="_blank" rel="noopener noreferrer">[?]</a>
		</th>
		<td>
			<p>
				<label for="<?php $this->field_id( 'noindex' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'noindex' ); ?>" id="<?php $this->field_id( 'noindex' ); ?>" value="1" <?php checked( $this->get_field_value( 'noindex' ) ); ?> />
				<?php
					/* translators: Meta noindex attribute. */
					printf( esc_html__( 'Apply %s to this archive', 'genesis' ), genesis_code( 'noindex' ) );
				?>
				</label><br />

				<label for="<?php $this->field_id( 'nofollow' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'nofollow' ); ?>" id="<?php $this->field_id( 'nofollow' ); ?>" value="1" <?php checked( $this->get_field_value( 'nofollow' ) ); ?> />
				<?php
					/* translators: Meta nofollow attribute. */
					printf( esc_html__( 'Apply %s to this archive', 'genesis' ), genesis_code( 'nofollow' ) );
				?>
				</label><br />

				<label for="<?php $this->field_id( 'noarchive' ); ?>"><input type="checkbox" name="<?php $this->field_name( 'noarchive' ); ?>" id="<?php $this->field_id( 'noarchive' ); ?>" value="1" <?php checked( $this->get_field_value( 'noarchive' ) ); ?> />
				<?php
					/* translators: Meta noarchive attribute. */
					printf( esc_html__( 'Apply %s to this archive', 'genesis' ), genesis_code( 'noarchive' ) );
				?>
				</label>
			</p>
		</td>
	</tr>

</tbody>
</table>
