<?php
/**
 * Genesis Framework.
 *
 * WARNING: This file is part of the core Genesis Framework. DO NOT edit this file under any circumstances.
 * Please do all modifications in the form of a child theme.
 *
 * @package StudioPress\Genesis
 * @author  StudioPress
 * @license GPL-2.0-or-later
 * @link    https://my.studiopress.com/themes/genesis/
 */

wp_nonce_field( 'genesis_inpost_seo_save', 'genesis_inpost_seo_nonce' );
?>

<table class="form-table">
<tbody>

	<tr valign="top">
		<th scope="row"><label for="genesis_title"><?php esc_html_e( 'Document Title', 'genesis' ); ?><span class="screen-reader-text"> &lt;title&gt; Tag. </span></label></th>
		<td>
			<p><input class="large-text" type="text" name="genesis_seo[_genesis_title]" id="genesis_title" value="<?php echo esc_attr( genesis_get_custom_field( '_genesis_title' ) ); ?>" /></p>
			<p class="description"><?php esc_html_e( 'The Custom Document Title sets the page title as seen in browsers and search engines. ', 'genesis' ); ?></p>
			<p><span class="hide-if-no-js description">
				<?php
				/* translators: Title string length */
				printf( esc_html__( 'Characters Used: %s', 'genesis' ), '<span id="genesis_title_chars">' . esc_html( mb_strlen( genesis_get_custom_field( '_genesis_title' ) ) ) . '</span>' );
				?>
			</span></p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="genesis_description"><?php esc_html_e( 'Meta Description', 'genesis' ); ?><span class="screen-reader-text"> &lt;meta name=&quot;description&quot; /&gt;. </span></label></th>
		<td>
			<p><textarea class="widefat" name="genesis_seo[_genesis_description]" id="genesis_description" rows="4" cols="4"><?php echo esc_textarea( genesis_get_custom_field( '_genesis_description' ) ); ?></textarea></p>
			<p class="description"><?php esc_html_e( 'Text entered in the Meta Description field is used as the short page description under the title on search engine results pages.', 'genesis' ); ?></p>
			<p><span class="hide-if-no-js description">
				<?php
				/* translators: Description string length */
				printf( esc_html__( 'Characters Used: %s', 'genesis' ), '<span id="genesis_description_chars">' . esc_html( mb_strlen( genesis_get_custom_field( '_genesis_description' ) ) ) . '</span>' );
				?>
			</span></p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="genesis_keywords"><strong><?php esc_html_e( 'Meta Keywords', 'genesis' ); ?></strong><span class="screen-reader-text"> &lt;meta name=&quot;keywords&quot; /&gt;. </span></label></th>
		<td>
			<p><input class="large-text" type="text" name="genesis_seo[_genesis_keywords]" id="genesis_keywords" value="<?php echo esc_attr( genesis_get_custom_field( '_genesis_keywords' ) ); ?>" /></p>
			<p class="description"><?php esc_html_e( 'A comma-separated list of keywords relevant to the page can be entered in the Meta Keywords field. Keywords are generally ignored by Search Engines.', 'genesis' ); ?></p>
		</td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="genesis_canonical"><strong><?php esc_html_e( 'Canonical URL', 'genesis' ); ?></strong> <span class="screen-reader-text"> &lt;link rel=&quot;canonical&quot; /&gt;. </span></label></th>
		<td><p><input class="large-text" type="text" name="genesis_seo[_genesis_canonical_uri]" id="genesis_canonical" value="<?php echo esc_url( genesis_get_custom_field( '_genesis_canonical_uri' ) ); ?>" /></p></td>
	</tr>

	<tr valign="top">
		<th scope="row"><label for="genesis_redirect"><strong><?php esc_html_e( 'Custom Redirect URL', 'genesis' ); ?></strong><span class="screen-reader-text"> <?php esc_html_e( '301 Redirect.', 'genesis' ); ?> </span></label></th>
		<td><p><input class="large-text" type="text" name="genesis_seo[redirect]" id="genesis_redirect" value="<?php echo esc_url( genesis_get_custom_field( 'redirect' ) ); ?>" /></p></td>
	</tr>

	<tr valign="top">
		<th scope="row"><?php esc_html_e( 'Robots Meta Settings', 'genesis' ); ?>
			<a href="https://yoast.com/robots-meta-tags/" target="_blank" rel="noopener noreferrer">[?]</a>
		</th>
		<td>
			<p>
				<label for="genesis_noindex"><input type="checkbox" name="genesis_seo[_genesis_noindex]" id="genesis_noindex" value="1" <?php checked( genesis_get_custom_field( '_genesis_noindex' ) ); ?> />
				<?php
				/* translators: Meta noindex attribute. */
				printf( esc_html__( 'Apply %s to this post/page', 'genesis' ), genesis_code( 'noindex' ) );
				?>
				</label><br />
			</p>
			<p>
				<label for="genesis_nofollow"><input type="checkbox" name="genesis_seo[_genesis_nofollow]" id="genesis_nofollow" value="1" <?php checked( genesis_get_custom_field( '_genesis_nofollow' ) ); ?> />
				<?php
				/* translators: Meta nofollow attribute. */
				printf( esc_html__( 'Apply %s to this post/page', 'genesis' ), genesis_code( 'nofollow' ) );
				?>
				</label><br />
			</p>
			<p>
				<label for="genesis_noarchive"><input type="checkbox" name="genesis_seo[_genesis_noarchive]" id="genesis_noarchive" value="1" <?php checked( genesis_get_custom_field( '_genesis_noarchive' ) ); ?> />
				<?php
				/* translators: Meta noarchive attribute. */
				printf( esc_html__( 'Apply %s to this post/page', 'genesis' ), genesis_code( 'noarchive' ) );
				?>
				</label>
			</p>
		</td>
	</tr>

</tbody>
</table>
